/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.fdf.FDFCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDictionary;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;

public final class PDAcroForm
implements COSObjectable {
    private static final int FLAG_SIGNATURES_EXIST = 1;
    private static final int FLAG_APPEND_ONLY = 2;
    private final PDDocument document;
    private final COSDictionary dictionary;
    private Map<String, PDField> fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.FIELDS, (COSBase)new COSArray());
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.dictionary = form;
    }

    PDDocument getDocument() {
        return this.document;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public void importFDF(FDFDocument fdf) throws IOException {
        List<FDFField> fields = fdf.getCatalog().getFDF().getFields();
        if (fields != null) {
            for (FDFField field : fields) {
                FDFField fdfField = field;
                PDField docField = this.getField(fdfField.getPartialFieldName());
                if (docField == null) continue;
                docField.importFDF(fdfField);
            }
        }
    }

    public FDFDocument exportFDF() throws IOException {
        FDFDocument fdf = new FDFDocument();
        FDFCatalog catalog = fdf.getCatalog();
        FDFDictionary fdfDict = new FDFDictionary();
        catalog.setFDF(fdfDict);
        ArrayList<FDFField> fdfFields = new ArrayList<FDFField>();
        List<PDField> fields = this.getFields();
        for (PDField field : fields) {
            fdfFields.add(field.exportFDF());
        }
        fdfDict.setID(this.document.getDocument().getDocumentID());
        if (!fdfFields.isEmpty()) {
            fdfDict.setFields(fdfFields);
        }
        return fdf;
    }

    public List<PDField> getFields() {
        COSArray cosFields = (COSArray)this.dictionary.getDictionaryObject(COSName.FIELDS);
        if (cosFields == null) {
            return Collections.emptyList();
        }
        ArrayList<PDField> pdFields = new ArrayList<PDField>();
        for (int i = 0; i < cosFields.size(); ++i) {
            COSDictionary element = (COSDictionary)cosFields.getObject(i);
            if (element == null) continue;
            PDField field = PDField.fromDictionary(this, element, null);
            pdFields.add(field);
        }
        return new COSArrayList<PDField>(pdFields, cosFields);
    }

    public void setFields(List<PDField> fields) {
        this.dictionary.setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public void setCacheFields(boolean cache) throws IOException {
        if (cache) {
            this.fieldCache = new HashMap<String, PDField>();
            List<PDField> fields = this.getFields();
            for (PDField field : fields) {
                this.fieldCache.put(field.getFullyQualifiedName(), field);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDField getField(String fullyQualifiedName) throws IOException {
        PDField retval = null;
        if (this.fieldCache != null) {
            retval = this.fieldCache.get(fullyQualifiedName);
        } else {
            String[] nameSubSection = fullyQualifiedName.split("\\.");
            COSArray fields = (COSArray)this.dictionary.getDictionaryObject(COSName.FIELDS);
            for (int i = 0; i < fields.size() && retval == null; ++i) {
                COSString fieldName;
                COSDictionary element = (COSDictionary)fields.getObject(i);
                if (element == null || !(fieldName = (COSString)element.getDictionaryObject(COSName.T)).getString().equals(fullyQualifiedName) && !fieldName.getString().equals(nameSubSection[0])) continue;
                PDField root = PDField.fromDictionary(this, element, null);
                if (nameSubSection.length > 1) {
                    PDField kid = root.findKid(nameSubSection, 1);
                    if (kid != null) {
                        retval = kid;
                        continue;
                    }
                    retval = root;
                    continue;
                }
                retval = root;
            }
        }
        return retval;
    }

    public String getDefaultAppearance() {
        COSString defaultAppearance = (COSString)this.dictionary.getItem(COSName.DA);
        return defaultAppearance.getString();
    }

    public void setDefaultAppearance(String daValue) {
        this.dictionary.setString(COSName.DA, daValue);
    }

    public boolean getNeedAppearances() {
        return this.dictionary.getBoolean(COSName.NEED_APPEARANCES, false);
    }

    public void setNeedAppearances(Boolean value) {
        this.dictionary.setBoolean(COSName.NEED_APPEARANCES, (boolean)value);
    }

    public PDResources getDefaultResources() {
        PDResources retval = null;
        COSDictionary dr = (COSDictionary)this.dictionary.getDictionaryObject(COSName.DR);
        if (dr != null) {
            retval = new PDResources(dr);
        }
        return retval;
    }

    public void setDefaultResources(PDResources dr) {
        this.dictionary.setItem(COSName.DR, (COSObjectable)dr);
    }

    public boolean hasXFA() {
        return this.dictionary.containsKey(COSName.XFA);
    }

    public boolean xfaIsDynamic() {
        return this.hasXFA() && this.getFields().isEmpty();
    }

    public PDXFAResource getXFA() {
        PDXFAResource xfa = null;
        COSBase base = this.dictionary.getDictionaryObject(COSName.XFA);
        if (base != null) {
            xfa = new PDXFAResource(base);
        }
        return xfa;
    }

    public void setXFA(PDXFAResource xfa) {
        this.dictionary.setItem(COSName.XFA, (COSObjectable)xfa);
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.dictionary.getDictionaryObject(COSName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.dictionary.setInt(COSName.Q, q);
    }

    public boolean isSignaturesExist() {
        return this.dictionary.getFlag(COSName.SIG_FLAGS, 1);
    }

    public void setSignaturesExist(boolean signaturesExist) {
        this.dictionary.setFlag(COSName.SIG_FLAGS, 1, signaturesExist);
    }

    public boolean isAppendOnly() {
        return this.dictionary.getFlag(COSName.SIG_FLAGS, 2);
    }

    public void setAppendOnly(boolean appendOnly) {
        this.dictionary.setFlag(COSName.SIG_FLAGS, 2, appendOnly);
    }
}

