/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

class PDAppearanceString {
    private final List<Object> tokens;
    private final PDResources defaultResources;

    PDAppearanceString(COSString defaultAppearance, PDResources defaultResources) throws IOException {
        if (defaultAppearance == null) {
            throw new IllegalArgumentException("/DA is a required entry");
        }
        if (defaultResources == null) {
            throw new IllegalArgumentException("/DR is a required entry");
        }
        PDFStreamParser parser = new PDFStreamParser(new RandomAccessBuffer(defaultAppearance.getBytes()));
        parser.parse();
        this.tokens = parser.getTokens();
        this.defaultResources = defaultResources;
    }

    public float getFontSize() {
        int fontIndex;
        if (!this.tokens.isEmpty() && (fontIndex = this.tokens.indexOf(Operator.getOperator("Tf"))) != -1) {
            return ((COSNumber)this.tokens.get(fontIndex - 1)).floatValue();
        }
        return 12.0f;
    }

    public float getLineWidth() {
        float retval = 0.0f;
        if (this.tokens != null) {
            int btIndex = this.tokens.indexOf(Operator.getOperator("BT"));
            int wIndex = this.tokens.indexOf(Operator.getOperator("w"));
            if (wIndex > 0 && (wIndex < btIndex || btIndex == -1)) {
                retval = ((COSNumber)this.tokens.get(wIndex - 1)).floatValue();
            }
        }
        return retval;
    }

    public PDFont getFont() throws IOException {
        COSName name = this.getFontResourceName();
        PDFont font = this.defaultResources.getFont(name);
        if (font == null) {
            throw new IOException("Could not find font: /" + name.getName());
        }
        return font;
    }

    private COSName getFontResourceName() {
        int setFontOperatorIndex = this.tokens.indexOf(Operator.getOperator("Tf"));
        return (COSName)this.tokens.get(setFontOperatorIndex - 2);
    }

    void writeTo(PDPageContentStream contents, float zeroFontSize) throws IOException {
        float fontSize = this.getFontSize();
        if (fontSize == 0.0f) {
            fontSize = zeroFontSize;
        }
        contents.setFont(this.getFont(), fontSize);
    }

    void copyNeededResourcesTo(PDAppearanceStream appearanceStream) throws IOException {
        COSName fontName;
        PDResources streamResources = appearanceStream.getResources();
        if (streamResources == null) {
            streamResources = new PDResources();
            appearanceStream.setResources(streamResources);
        }
        if (streamResources.getFont(fontName = this.getFontResourceName()) == null) {
            streamResources.put(fontName, this.getFont());
        }
    }
}

