/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;

public class PDResources
implements COSObjectable {
    private final COSDictionary resources;
    private final Map<COSName, PDFont> cachedFonts = new HashMap<COSName, PDFont>();
    private final Map<COSName, PDColorSpace> cachedColorSpaces = new HashMap<COSName, PDColorSpace>();
    private final Map<COSName, PDExtendedGraphicsState> cachedExtGStates = new HashMap<COSName, PDExtendedGraphicsState>();
    private final Map<COSName, PDShading> cachedShadings = new HashMap<COSName, PDShading>();
    private final Map<COSName, PDAbstractPattern> cachedPatterns = new HashMap<COSName, PDAbstractPattern>();
    private final Map<COSName, PDPropertyList> cachedPropertiesLists = new HashMap<COSName, PDPropertyList>();
    private final Map<COSName, PDXObject> cachedXObjects = new HashMap<COSName, PDXObject>();

    public PDResources() {
        this.resources = new COSDictionary();
    }

    public PDResources(COSDictionary resourceDictionary) {
        if (resourceDictionary == null) {
            throw new IllegalArgumentException("resourceDictionary is null");
        }
        this.resources = resourceDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.resources;
    }

    public PDFont getFont(COSName name) throws IOException {
        if (this.cachedFonts.containsKey(name)) {
            return this.cachedFonts.get(name);
        }
        COSDictionary dict = (COSDictionary)this.get(COSName.FONT, name);
        if (dict == null) {
            return null;
        }
        PDFont font = PDFontFactory.createFont(dict);
        this.cachedFonts.put(name, font);
        return font;
    }

    public PDColorSpace getColorSpace(COSName name) throws IOException {
        return this.getColorSpace(name, false);
    }

    public PDColorSpace getColorSpace(COSName name, boolean wasDefault) throws IOException {
        if (this.cachedColorSpaces.containsKey(name)) {
            return this.cachedColorSpaces.get(name);
        }
        COSBase object = this.get(COSName.COLORSPACE, name);
        if (object != null) {
            PDColorSpace colorSpace = PDColorSpace.create(object, this, wasDefault);
            this.cachedColorSpaces.put(name, colorSpace);
            return colorSpace;
        }
        PDColorSpace colorSpace = PDColorSpace.create(name, this, wasDefault);
        this.cachedColorSpaces.put(name, colorSpace);
        return colorSpace;
    }

    public boolean hasColorSpace(COSName name) {
        return this.get(COSName.COLORSPACE, name) != null;
    }

    public PDExtendedGraphicsState getExtGState(COSName name) {
        if (this.cachedExtGStates.containsKey(name)) {
            return this.cachedExtGStates.get(name);
        }
        COSDictionary dict = (COSDictionary)this.get(COSName.EXT_G_STATE, name);
        if (dict == null) {
            return null;
        }
        PDExtendedGraphicsState state = new PDExtendedGraphicsState(dict);
        this.cachedExtGStates.put(name, state);
        return state;
    }

    public PDShading getShading(COSName name) throws IOException {
        if (this.cachedShadings.containsKey(name)) {
            return this.cachedShadings.get(name);
        }
        COSDictionary dict = (COSDictionary)this.get(COSName.SHADING, name);
        if (dict == null) {
            return null;
        }
        PDShading shading = PDShading.create(dict);
        this.cachedShadings.put(name, shading);
        return shading;
    }

    public PDAbstractPattern getPattern(COSName name) throws IOException {
        if (this.cachedPatterns.containsKey(name)) {
            return this.cachedPatterns.get(name);
        }
        COSDictionary dict = (COSDictionary)this.get(COSName.PATTERN, name);
        if (dict == null) {
            return null;
        }
        PDAbstractPattern pattern = PDAbstractPattern.create(dict);
        this.cachedPatterns.put(name, pattern);
        return pattern;
    }

    public PDPropertyList getProperties(COSName name) {
        if (this.cachedPropertiesLists.containsKey(name)) {
            return this.cachedPropertiesLists.get(name);
        }
        COSDictionary dict = (COSDictionary)this.get(COSName.PROPERTIES, name);
        if (dict == null) {
            return null;
        }
        PDPropertyList propertyList = PDPropertyList.create(dict);
        this.cachedPropertiesLists.put(name, propertyList);
        return propertyList;
    }

    public PDXObject getXObject(COSName name) throws IOException {
        PDXObject xObject;
        if (this.cachedXObjects.containsKey(name)) {
            return this.cachedXObjects.get(name);
        }
        COSBase value = this.get(COSName.XOBJECT, name);
        if (value == null) {
            return null;
        }
        if (value instanceof COSObject) {
            COSObject object = (COSObject)value;
            String id = name.getName();
            id = id + "#" + object.getObjectNumber();
            xObject = PDXObject.createXObject(object.getObject(), id, this);
        } else {
            xObject = PDXObject.createXObject(value, name.getName(), this);
        }
        this.cachedXObjects.put(name, xObject);
        return xObject;
    }

    private COSBase get(COSName kind, COSName name) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return null;
        }
        return dict.getDictionaryObject(name);
    }

    public Iterable<COSName> getColorSpaceNames() {
        return this.getNames(COSName.COLORSPACE);
    }

    public Iterable<COSName> getXObjectNames() {
        return this.getNames(COSName.XOBJECT);
    }

    public Iterable<COSName> getFontNames() {
        return this.getNames(COSName.FONT);
    }

    public Iterable<COSName> getPropertiesNames() {
        return this.getNames(COSName.PROPERTIES);
    }

    public Iterable<COSName> getShadingNames() {
        return this.getNames(COSName.SHADING);
    }

    public Iterable<COSName> getPatternNames() {
        return this.getNames(COSName.PATTERN);
    }

    public Iterable<COSName> getExtGStateNames() {
        return this.getNames(COSName.EXT_G_STATE);
    }

    private Iterable<COSName> getNames(COSName kind) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return Collections.emptySet();
        }
        return dict.keySet();
    }

    public COSName add(PDFont font) {
        return this.add(COSName.FONT, "F", font);
    }

    public COSName add(PDColorSpace colorSpace) {
        return this.add(COSName.COLORSPACE, "cs", colorSpace);
    }

    public COSName add(PDExtendedGraphicsState extGState) {
        return this.add(COSName.EXT_G_STATE, "gs", extGState);
    }

    public COSName add(PDShading shading) {
        return this.add(COSName.SHADING, "sh", shading);
    }

    public COSName add(PDAbstractPattern pattern) {
        return this.add(COSName.PATTERN, "p", pattern);
    }

    public COSName add(PDPropertyList properties) {
        if (properties instanceof PDOptionalContentGroup) {
            return this.add(COSName.PROPERTIES, "oc", properties);
        }
        return this.add(COSName.PROPERTIES, "Prop", properties);
    }

    public COSName add(PDImageXObject image) {
        return this.add(COSName.XOBJECT, "Im", image);
    }

    public COSName add(PDFormXObject form) {
        return this.add(COSName.XOBJECT, "Form", form);
    }

    public COSName add(PDXObject xobject, String prefix) {
        return this.add(COSName.XOBJECT, prefix, xobject);
    }

    private COSName add(COSName kind, String prefix, COSObjectable object) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict != null && dict.containsValue(object.getCOSObject())) {
            return dict.getKeyForValue(object.getCOSObject());
        }
        COSName name = this.createKey(kind, prefix);
        this.put(kind, name, object);
        return name;
    }

    private COSName createKey(COSName kind, String prefix) {
        String key;
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return COSName.getPDFName(prefix + 1);
        }
        int n = dict.keySet().size();
        while (dict.containsKey(key = prefix + ++n)) {
        }
        return COSName.getPDFName(key);
    }

    private void put(COSName kind, COSName name, COSObjectable object) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            dict = new COSDictionary();
            this.resources.setItem(kind, (COSBase)dict);
        }
        dict.setItem(name, object);
    }

    public void put(COSName name, PDFont font) {
        this.put(COSName.FONT, name, font);
    }

    public void put(COSName name, PDColorSpace colorSpace) {
        this.put(COSName.COLORSPACE, name, colorSpace);
    }

    public void put(COSName name, PDExtendedGraphicsState extGState) {
        this.put(COSName.EXT_G_STATE, name, extGState);
    }

    public void put(COSName name, PDShading shading) {
        this.put(COSName.SHADING, name, shading);
    }

    public void put(COSName name, PDAbstractPattern pattern) {
        this.put(COSName.PATTERN, name, pattern);
    }

    public void put(COSName name, PDPropertyList properties) {
        this.put(COSName.PROPERTIES, name, properties);
    }

    public void put(COSName name, PDXObject xobject) {
        this.put(COSName.XOBJECT, name, xobject);
    }
}

