/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.verapdf.model.factory.operator.OperatorFactory;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDContentStream
extends PBoxPDObject
implements PDContentStream {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDContentStream.class.getCanonicalName());
    public static final String CONTENT_STREAM_TYPE = "PDContentStream";
    public static final String OPERATORS = "operators";
    private static final String RESOURCES = "resources";
    private final PDInheritableResources resources;
    private List<Operator> operators = null;
    private boolean containsTransparency = false;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDContentStream(org.apache.pdfbox.contentstream.PDContentStream contentStream, PDInheritableResources resources, PDDocument document, PDFAFlavour flavour) {
        super(contentStream, CONTENT_STREAM_TYPE);
        this.resources = resources;
        this.document = document;
        this.flavour = flavour;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "operators": {
                return this.getOperators();
            }
            case "resources": {
                return this.getResources();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<Operator> getOperators() {
        if (this.operators == null) {
            this.parseOperators();
        }
        return this.operators;
    }

    public boolean isContainsTransparency() {
        if (this.operators == null) {
            this.parseOperators();
        }
        return this.containsTransparency;
    }

    private void parseOperators() {
        try {
            COSStream cStream = this.contentStream.getContentStream();
            if (cStream != null) {
                PDFStreamParser streamParser = new PDFStreamParser(cStream, true);
                streamParser.parse();
                OperatorFactory operatorFactory = new OperatorFactory();
                List<Operator> result = operatorFactory.operatorsFromTokens(streamParser.getTokens(), this.resources, this.document, this.flavour);
                this.containsTransparency = operatorFactory.isLastParsedContainsTransparency();
                this.operators = Collections.unmodifiableList(result);
            } else {
                this.operators = Collections.emptyList();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Error while parsing content stream. " + e.getMessage());
            this.operators = Collections.emptyList();
        }
    }

    @Override
    public String getundefinedResourceNames() {
        return this.resources.getUndefinedResourceNames().stream().map(COSName::getName).collect(Collectors.joining(","));
    }

    @Override
    public String getinheritedResourceNames() {
        return this.resources.getInheritedResourceNames().stream().map(COSName::getName).collect(Collectors.joining(","));
    }

    private List<org.verapdf.model.pdlayer.PDResources> getResources() {
        ArrayList<org.verapdf.model.pdlayer.PDResources> result = new ArrayList<org.verapdf.model.pdlayer.PDResources>(1);
        PDResources resources = this.resources.getCurrentResources();
        if (resources != null) {
            result.add(new PBoxPDResources(resources));
        }
        return result;
    }
}

