/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.graphics.PDFontSetting;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingIntent;
import org.verapdf.model.coslayer.CosBM;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.impl.pb.cos.PBCosBM;
import org.verapdf.model.impl.pb.cos.PBCosNumber;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDHalftone;
import org.verapdf.model.impl.pb.pd.PBoxPDResource;
import org.verapdf.model.impl.pb.pd.functions.PBoxPDFunction;
import org.verapdf.model.pdlayer.PDExtGState;
import org.verapdf.model.pdlayer.PDHalftone;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDExtGState
extends PBoxPDResource
implements PDExtGState {
    public static final String EXT_G_STATE_TYPE = "PDExtGState";
    public static final String CUSTOM_FUNCTIONS = "customFunctions";
    public static final String RI = "RI";
    public static final String FONT_SIZE = "fontSize";
    public static final String HALFTONE = "HT";
    public static final String LINK_BM = "bm";
    private final String tr;
    private final String tr2;
    private final String sMask;
    private final String BM;
    private final Double ca;
    private final Double CA;
    private final PDFAFlavour flavour;

    public PBoxPDExtGState(PDExtendedGraphicsState state, PDFAFlavour flavour) {
        super(state, EXT_G_STATE_TYPE);
        this.tr = PBoxPDExtGState.getStringProperty(state, COSName.TR);
        this.tr2 = PBoxPDExtGState.getStringProperty(state, COSName.getPDFName("TR2"));
        this.sMask = PBoxPDExtGState.getStringProperty(state, COSName.SMASK);
        this.BM = PBoxPDExtGState.getStringProperty(state, COSName.BM);
        this.ca = PBoxPDExtGState.getDoubleProperty(state, COSName.CA_NS);
        this.CA = PBoxPDExtGState.getDoubleProperty(state, COSName.CA);
        this.flavour = flavour;
    }

    @Override
    public String getTR() {
        return this.tr;
    }

    @Override
    public String getTR2() {
        return this.tr2;
    }

    @Override
    public String getSMask() {
        return this.sMask;
    }

    @Override
    public String getBM() {
        return this.BM;
    }

    @Override
    public Double getca() {
        return this.ca;
    }

    @Override
    public Double getCA() {
        return this.CA;
    }

    @Override
    public Boolean getcontainsHTP() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName("HTP"));
    }

    @Override
    public Boolean getcontainsHTO() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName("HTO"));
    }

    private static String getStringProperty(PDExtendedGraphicsState state, COSName key) {
        COSBase base = state.getCOSObject().getDictionaryObject(key);
        return base == null ? null : (base instanceof COSName ? ((COSName)base).getName() : base.toString());
    }

    private static Double getDoubleProperty(PDExtendedGraphicsState state, COSName key) {
        COSBase base = state.getCOSObject().getDictionaryObject(key);
        return !(base instanceof COSNumber) ? null : Double.valueOf(((COSNumber)base).doubleValue());
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "RI": {
                return this.getRI();
            }
            case "fontSize": {
                return this.getFontSize();
            }
            case "HT": {
                return this.getHalftone();
            }
            case "customFunctions": {
                return this.getCustomFunctions();
            }
            case "bm": {
                return this.getLinkBM();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CosBM> getLinkBM() {
        COSBase BM = ((COSDictionary)this.simplePDObject.getCOSObject()).getDictionaryObject(COSName.BM);
        if (BM == null) {
            return Collections.emptyList();
        }
        if ((this.flavour == null || this.flavour.getPart() != PDFAFlavour.Specification.ISO_19005_4) && BM instanceof COSArray) {
            COSArray array = (COSArray)BM;
            for (COSBase obj : array) {
                if (!(obj instanceof COSName)) continue;
                BM = obj;
                break;
            }
        }
        if (BM instanceof COSName) {
            ArrayList<PBCosBM> list = new ArrayList<PBCosBM>(1);
            list.add(new PBCosBM((COSName)BM));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosRenderingIntent> getRI() {
        RenderingIntent renderingIntent = ((PDExtendedGraphicsState)this.simplePDObject).getRenderingIntent();
        if (renderingIntent != null) {
            ArrayList<PBCosRenderingIntent> renderingIntents = new ArrayList<PBCosRenderingIntent>(1);
            COSName pdfName = COSName.getPDFName(renderingIntent.stringValue());
            renderingIntents.add(new PBCosRenderingIntent(pdfName));
            return Collections.unmodifiableList(renderingIntents);
        }
        return Collections.emptyList();
    }

    private List<CosNumber> getFontSize() {
        PDFontSetting fontSetting = ((PDExtendedGraphicsState)this.simplePDObject).getFontSetting();
        if (fontSetting != null) {
            ArrayList<PBCosNumber> result = new ArrayList<PBCosNumber>(1);
            COSNumber size = (COSNumber)((COSArray)fontSetting.getCOSObject()).get(1);
            result.add(PBCosNumber.fromPDFBoxNumber(size));
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List<PDHalftone> getHalftone() {
        COSDictionary dict = ((PDExtendedGraphicsState)this.simplePDObject).getCOSObject();
        COSBase halftone = dict.getDictionaryObject(COSName.getPDFName(HALFTONE));
        boolean isDictionary = halftone instanceof COSDictionary;
        if (isDictionary || halftone instanceof COSName) {
            ArrayList<PBoxPDHalftone> list = new ArrayList<PBoxPDHalftone>(1);
            if (isDictionary) {
                list.add(new PBoxPDHalftone((COSDictionary)halftone));
            } else {
                list.add(new PBoxPDHalftone((COSName)halftone));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PBoxPDFunction> getCustomFunctions() {
        return Collections.emptyList();
    }
}

