/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports.multithread.writer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.writer.AbstractXmlReportWriter;
import org.xml.sax.SAXException;

public class RawReportWriter
extends AbstractXmlReportWriter {
    private static final Logger LOGGER = Logger.getLogger(RawReportWriter.class.getCanonicalName());
    private final String RAW_RESULTS_TAG = "rawResults";
    private final String ITEM_TAG = "item";
    private final String VALIDATION_RESULT_TAG = "validationResult";
    private final String PROCESSOR_CONFIG_TAG = "processorConfig";
    private final String FEATURES_REPORT_TAG = "featuresReport";
    private final String FIXER_RESULT_TAG = "fixerResult";

    protected RawReportWriter(PrintWriter outputStreamWriter, PrintWriter errorStreamWriter) throws XMLStreamException, ParserConfigurationException, SAXException {
        super(outputStreamWriter, errorStreamWriter);
    }

    @Override
    public synchronized void write(ResultStructure result) {
        try {
            File reportFile = result.getReportFile();
            if (this.isFirstReport) {
                this.writer.writeStartElement("rawResults");
                this.printFirstReport(reportFile);
                this.isFirstReport = false;
            } else {
                this.printReport(reportFile);
            }
            this.deleteTemp(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't printTag element", e);
        }
    }

    private void printReport(File reportFile) throws SAXException, IOException {
        super.printTag(reportFile, "item", false);
        super.printTag(reportFile, "validationResult", true);
        super.printTag(reportFile, "featuresReport", false);
        super.printTag(reportFile, "fixerResult", false);
    }

    @Override
    public void printFirstReport(File report) throws SAXException, IOException {
        this.printTag(report, "processorConfig", false);
        this.printReport(report);
    }
}

