/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;

public final class PDCheckbox
extends PDButton {
    public PDCheckbox(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDCheckbox(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isChecked() {
        return this.getValue();
    }

    public void check() throws IOException {
        this.setValue(true);
    }

    public void unCheck() throws IOException {
        this.setValue(false);
    }

    public boolean getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        return value instanceof COSName && value.equals(COSName.YES);
    }

    public Boolean getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value == null) {
            return null;
        }
        return value instanceof COSName && value.equals(COSName.YES);
    }

    @Override
    public String getValueAsString() {
        return this.getValue() ? "Yes" : "Off";
    }

    public void setValue(boolean value) throws IOException {
        COSName name = value ? COSName.YES : COSName.OFF;
        this.dictionary.setItem(COSName.V, (COSBase)name);
        this.dictionary.setItem(COSName.AS, (COSBase)name);
        this.applyChange();
    }

    public void setDefaultValue(boolean value) throws IOException {
        COSName name = value ? COSName.YES : COSName.OFF;
        this.dictionary.setItem(COSName.DV, (COSBase)name);
    }
}

