/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosTrailer;
import org.verapdf.model.coslayer.CosXRef;
import org.verapdf.model.impl.pb.cos.PBCosFileSpecification;
import org.verapdf.model.impl.pb.cos.PBCosIndirect;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.cos.PBCosTrailer;
import org.verapdf.model.impl.pb.cos.PBCosXRef;
import org.verapdf.model.impl.pb.pd.PBoxPDDocument;
import org.verapdf.model.tools.FileSpecificationKeysHelper;
import org.verapdf.model.tools.XMPChecker;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosDocument
extends PBCosObject
implements CosDocument {
    private static final Logger LOGGER = Logger.getLogger(PBCosDocument.class.getCanonicalName());
    public static final String COS_DOCUMENT_TYPE = "CosDocument";
    public static final String TRAILER = "trailer";
    public static final String XREF = "xref";
    public static final String INDIRECT_OBJECTS = "indirectObjects";
    public static final String DOCUMENT = "document";
    public static final String DOC = "doc";
    public static final String EMBEDDED_FILES = "EmbeddedFiles";
    public static final String ID = "ID";
    public static final String REQUIREMENTS = "Requirements";
    public static final COSName PIECE_INFO = COSName.getPDFName("PieceInfo");
    private final PDFAFlavour flavour;
    private PDDocument pdDocument;
    private final long indirectObjectCount;
    private final float headerVersion;
    private final long headerOffset;
    private final String header;
    private final int headerCommentByte1;
    private final int headerCommentByte2;
    private final int headerCommentByte3;
    private final int headerCommentByte4;
    private final boolean isOptionalContentPresent;
    private final boolean isLinearised;
    private final int postEOFDataSize;
    private final Boolean doesInfoMatchXMP;
    private final String firstPageID;
    private final String lastID;
    private final boolean needsRendering;
    private final COSDictionary catalog = this.getCatalog();

    public PBCosDocument(PDDocument pdDocument, PDFAFlavour flavour) {
        this(pdDocument.getDocument(), flavour);
        this.pdDocument = pdDocument;
        if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_3) {
            FileSpecificationKeysHelper.registerFileSpecificationKeys(pdDocument);
        }
    }

    public PBCosDocument(COSDocument cosDocument, PDFAFlavour flavour) {
        super(cosDocument, COS_DOCUMENT_TYPE);
        this.flavour = flavour;
        this.indirectObjectCount = cosDocument.getObjects().size();
        this.headerVersion = cosDocument.getVersion();
        this.headerOffset = cosDocument.getHeaderOffset();
        this.header = cosDocument.getHeader();
        this.headerCommentByte1 = cosDocument.getHeaderCommentByte1();
        this.headerCommentByte2 = cosDocument.getHeaderCommentByte2();
        this.headerCommentByte3 = cosDocument.getHeaderCommentByte3();
        this.headerCommentByte4 = cosDocument.getHeaderCommentByte4();
        this.isOptionalContentPresent = this.parseOptionalContentPresent();
        this.postEOFDataSize = cosDocument.getPostEOFDataSize();
        this.lastID = cosDocument.getLastTrailer() != null ? PBCosDocument.getTrailerID((COSArray)cosDocument.getLastTrailer().getDictionaryObject(ID)) : null;
        this.firstPageID = cosDocument.getFirstPageTrailer() != null ? PBCosDocument.getTrailerID((COSArray)cosDocument.getFirstPageTrailer().getDictionaryObject(ID)) : null;
        this.isLinearised = cosDocument.getTrailer() != cosDocument.getLastTrailer() && cosDocument.isLinearized();
        this.doesInfoMatchXMP = XMPChecker.doesInfoMatchXMP(cosDocument);
        this.needsRendering = this.getNeedsRenderingValue();
    }

    private boolean parseOptionalContentPresent() {
        return this.catalog != null && this.catalog.getDictionaryObject(COSName.OCPROPERTIES) != null;
    }

    @Override
    public Long getnrIndirects() {
        return this.indirectObjectCount;
    }

    @Override
    public Double getheaderVersion() {
        return this.headerVersion;
    }

    @Override
    public Long getheaderOffset() {
        return this.headerOffset;
    }

    @Override
    public String getheader() {
        return this.header;
    }

    @Override
    public Long getheaderByte1() {
        return this.headerCommentByte1;
    }

    @Override
    public Long getheaderByte2() {
        return this.headerCommentByte2;
    }

    @Override
    public Long getheaderByte3() {
        return this.headerCommentByte3;
    }

    @Override
    public Long getheaderByte4() {
        return this.headerCommentByte4;
    }

    @Override
    public Boolean getisOptionalContentPresent() {
        return this.isOptionalContentPresent;
    }

    @Override
    public Long getpostEOFDataSize() {
        return this.postEOFDataSize;
    }

    @Override
    public String getfirstPageID() {
        return this.firstPageID;
    }

    @Override
    public String getlastID() {
        if (this.flavour.getPart().equals((Object)PDFAFlavour.Specification.ISO_19005_1)) {
            return this.lastID;
        }
        if (this.isLinearised) {
            return this.firstPageID;
        }
        return this.lastID;
    }

    @Override
    public String getfirstPageIDValue() {
        return null;
    }

    @Override
    public String getlastIDValue() {
        return null;
    }

    private static String getTrailerID(COSArray ids) {
        if (ids != null) {
            StringBuilder builder = new StringBuilder();
            for (COSBase id : ids) {
                for (byte aByte : ((COSString)id).getBytes()) {
                    builder.append((char)(aByte & 0xFF));
                }
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public Boolean getisLinearized() {
        return this.isLinearised;
    }

    @Override
    public Boolean getdoesInfoMatchXMP() {
        return this.doesInfoMatchXMP;
    }

    @Override
    public Boolean getMarked() {
        if (this.catalog != null) {
            COSBase markInfo = this.catalog.getDictionaryObject(COSName.MARK_INFO);
            if (markInfo == null) {
                return null;
            }
            if (markInfo instanceof COSDictionary) {
                COSName marked = COSName.getPDFName("Marked");
                boolean value = ((COSDictionary)markInfo).getBoolean(marked, false);
                return value;
            }
            LOGGER.log(Level.INFO, "MarkedInfo must be a 'COSDictionary' but got: " + markInfo.getClass().getSimpleName());
            return null;
        }
        return null;
    }

    @Override
    public Boolean getSuspects() {
        if (this.catalog != null) {
            COSBase markInfo = this.catalog.getDictionaryObject(COSName.MARK_INFO);
            if (markInfo == null) {
                return null;
            }
            if (markInfo instanceof COSDictionary) {
                COSName suspects = COSName.getPDFName("Suspects");
                return ((COSDictionary)markInfo).getBoolean(suspects, false);
            }
            LOGGER.log(Level.INFO, "MarkedInfo must be a 'COSDictionary' but got: " + markInfo.getClass().getSimpleName());
            return null;
        }
        return null;
    }

    @Override
    public Boolean getDisplayDocTitle() {
        if (this.catalog != null) {
            COSBase viewerPref = this.catalog.getDictionaryObject(COSName.VIEWER_PREFERENCES);
            if (viewerPref == null) {
                return null;
            }
            if (viewerPref instanceof COSDictionary) {
                COSName displayDocTitle = COSName.getPDFName("DisplayDocTitle");
                boolean value = ((COSDictionary)viewerPref).getBoolean(displayDocTitle, false);
                return value;
            }
            LOGGER.log(Level.INFO, "viewerPref must be a 'COSDictionary' but got: " + viewerPref.getClass().getSimpleName());
            return null;
        }
        return null;
    }

    @Override
    public Boolean getcontainsInfo() {
        return ((COSDocument)this.baseObject).getTrailer().getDictionaryObject(COSName.INFO) != null;
    }

    @Override
    public Boolean getcontainsPieceInfo() {
        return this.catalog != null && this.catalog.getDictionaryObject(PIECE_INFO) != null;
    }

    @Override
    public String getMarkInfo() {
        return null;
    }

    @Override
    public String getViewerPreferences() {
        return null;
    }

    @Override
    public String getRequirements() {
        COSBase reqArray;
        if (this.catalog != null && (reqArray = this.catalog.getDictionaryObject(COSName.getPDFName(REQUIREMENTS))) instanceof COSArray) {
            return PBCosDocument.getRequirementsString(reqArray);
        }
        return null;
    }

    private static String getRequirementsString(COSBase reqArray) {
        String result = "";
        for (COSBase element : (COSArray)reqArray) {
            if (!(element instanceof COSDictionary)) continue;
            String sKey = ((COSDictionary)element).getString(COSName.S);
            result = result + sKey;
            result = result + " ";
        }
        return result;
    }

    @Override
    public Boolean getNeedsRendering() {
        return this.needsRendering;
    }

    @Override
    public Boolean getcontainsEmbeddedFiles() {
        COSBase names;
        if (this.catalog != null && (names = this.catalog.getDictionaryObject(COSName.NAMES)) != null && names instanceof COSDictionary) {
            return ((COSDictionary)names).containsKey(COSName.EMBEDDED_FILES);
        }
        return false;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "trailer": {
                return this.getTrailer();
            }
            case "indirectObjects": {
                return this.getIndirectObjects();
            }
            case "document": {
                return this.getDocument();
            }
            case "xref": {
                return this.getXRefs();
            }
            case "EmbeddedFiles": {
                return this.getEmbeddedFiles();
            }
            case "doc": {
                return Collections.emptyList();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.baselayer.Object> getEmbeddedFiles() {
        COSBase base;
        COSDictionary buffer;
        if (this.catalog != null && (buffer = (COSDictionary)this.catalog.getDictionaryObject(COSName.NAMES)) != null && (base = buffer.getDictionaryObject(COSName.EMBEDDED_FILES)) instanceof COSDictionary) {
            ArrayList<org.verapdf.model.baselayer.Object> files = new ArrayList<org.verapdf.model.baselayer.Object>();
            this.getNamesEmbeddedFiles(files, new PDEmbeddedFilesNameTreeNode((COSDictionary)base));
            return Collections.unmodifiableList(files);
        }
        return Collections.emptyList();
    }

    private void getNamesEmbeddedFiles(List<org.verapdf.model.baselayer.Object> files, PDNameTreeNode<PDComplexFileSpecification> node) {
        try {
            Map<String, PDComplexFileSpecification> names = node.getNames();
            if (names != null) {
                Set<Map.Entry<String, PDComplexFileSpecification>> entries = names.entrySet();
                for (Map.Entry<String, PDComplexFileSpecification> entry : entries) {
                    files.add(new PBCosFileSpecification(entry.getValue().getCOSObject(), this.pdDocument, this.flavour));
                }
            }
            if (node.getKids() != null) {
                for (PDNameTreeNode<PDComplexFileSpecification> kid : node.getKids()) {
                    this.getNamesEmbeddedFiles(files, kid);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Something wrong with getting embedded files - return empty list. " + e.getMessage());
        }
    }

    private List<CosTrailer> getTrailer() {
        COSDocument cosDocument = (COSDocument)this.baseObject;
        ArrayList<PBCosTrailer> list = new ArrayList<PBCosTrailer>(1);
        list.add(new PBCosTrailer(cosDocument.getTrailer(), this.pdDocument, this.flavour));
        return Collections.unmodifiableList(list);
    }

    private List<CosIndirect> getIndirectObjects() {
        List<COSObject> objects = ((COSDocument)this.baseObject).getObjects();
        ArrayList<PBCosIndirect> list = new ArrayList<PBCosIndirect>(objects.size());
        for (COSObject object : objects) {
            list.add(new PBCosIndirect(object, this.pdDocument, this.flavour));
        }
        return Collections.unmodifiableList(list);
    }

    private List<org.verapdf.model.pdlayer.PDDocument> getDocument() {
        if (this.pdDocument != null) {
            ArrayList<PBoxPDDocument> document = new ArrayList<PBoxPDDocument>(1);
            document.add(new PBoxPDDocument(this.pdDocument, this.flavour));
            return Collections.unmodifiableList(document);
        }
        return Collections.emptyList();
    }

    private List<CosXRef> getXRefs() {
        COSDocument cosDocument = (COSDocument)this.baseObject;
        ArrayList<PBCosXRef> list = new ArrayList<PBCosXRef>(1);
        list.add(new PBCosXRef(cosDocument.subSectionHeaderSpaceSeparated(), cosDocument.isXrefEOLMarkersComplyPDFA()));
        return Collections.unmodifiableList(list);
    }

    private boolean getNeedsRenderingValue() {
        COSName needsRenderingLocal = COSName.getPDFName("NeedsRendering");
        return this.catalog != null && this.catalog.getBoolean(needsRenderingLocal, false);
    }

    private COSDictionary getCatalog() {
        COSBase catalogLocal = ((COSDocument)this.baseObject).getTrailer().getDictionaryObject(COSName.ROOT);
        return catalogLocal instanceof COSDictionary ? (COSDictionary)catalogLocal : null;
    }
}

