/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosFileSpecification;
import org.verapdf.model.external.EmbeddedFile;
import org.verapdf.model.impl.pb.containers.StaticContainers;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.external.PBoxEmbeddedFile;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBCosFileSpecification
extends PBCosDict
implements CosFileSpecification {
    public static final String COS_FILE_SPECIFICATION_TYPE = "CosFileSpecification";
    public static final String EF = "EF";
    private final String f = this.getStringValue(COSName.F);
    private final String uf = this.getStringValue(COSName.UF);
    private final String afrelationship = this.getNameValue(COSName.getPDFName("AFRelationship"));

    public PBCosFileSpecification(COSDictionary dictionary, PDDocument document, PDFAFlavour flavour) {
        super(dictionary, COS_FILE_SPECIFICATION_TYPE, document, flavour);
    }

    @Override
    public String getF() {
        return this.f;
    }

    @Override
    public String getUF() {
        return this.uf;
    }

    @Override
    public String getAFRelationship() {
        return this.afrelationship;
    }

    @Override
    public Boolean getisAssociatedFile() {
        return this.baseObject != null && StaticContainers.getFileSpecificationKeys().contains(this.baseObject.getKey());
    }

    @Override
    public Boolean getcontainsEF() {
        return this.baseObject != null && this.baseObject instanceof COSDictionary && ((COSDictionary)this.baseObject).containsKey(COSName.EF);
    }

    @Override
    public Boolean getcontainsDesc() {
        return null;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (EF.equals(link)) {
            return this.getEFFile();
        }
        return super.getLinkedObjects(link);
    }

    private List<EmbeddedFile> getEFFile() {
        COSBase efDictionary = ((COSDictionary)this.baseObject).getDictionaryObject(COSName.EF);
        if (efDictionary instanceof COSDictionary) {
            ArrayList<EmbeddedFile> list = new ArrayList<EmbeddedFile>();
            COSDictionary dict = (COSDictionary)efDictionary;
            this.addEFFile(list, dict, COSName.F);
            this.addEFFile(list, dict, COSName.UF);
            this.addEFFile(list, dict, COSName.DOS);
            this.addEFFile(list, dict, COSName.MAC);
            this.addEFFile(list, dict, COSName.UNIX);
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private void addEFFile(List<EmbeddedFile> list, COSDictionary dict, COSName name) {
        COSBase base = dict.getDictionaryObject(name);
        if (base != null) {
            list.add(new PBoxEmbeddedFile(base));
        }
    }

    private String getStringValue(COSName key) {
        COSBase value = ((COSDictionary)this.baseObject).getDictionaryObject(key);
        return value instanceof COSString ? ((COSString)value).getString() : null;
    }

    private String getNameValue(COSName key) {
        COSBase value = ((COSDictionary)this.baseObject).getDictionaryObject(key);
        return value instanceof COSName ? ((COSName)value).getName() : null;
    }
}

