/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.ScratchFileBuffer;

public class ScratchFile
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ScratchFile.class);
    private File file;
    private RandomAccessFile raf;

    public ScratchFile(File scratchFileDirectory) throws IOException {
        this.file = File.createTempFile("PDFBox", ".tmp", scratchFileDirectory);
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        catch (IOException e) {
            if (!this.file.delete()) {
                LOG.debug("Error deleting scratch file: " + this.file.getAbsolutePath());
            }
            throw e;
        }
    }

    RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    void checkClosed() throws IOException {
        if (this.raf == null) {
            throw new IOException("Scratch file already closed");
        }
    }

    public RandomAccess createBuffer() throws IOException {
        return new ScratchFileBuffer(this);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
        if (this.file != null) {
            if (this.file.delete()) {
                this.file = null;
            } else {
                throw new IOException("Error deleting scratch file: " + this.file.getAbsolutePath());
            }
        }
    }
}

