/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.graphic;

import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.graphic.ColorSpaces;
import org.apache.pdfbox.preflight.graphic.StandardColorSpaceHelper;

public class DeviceColorSpaceHelper
extends StandardColorSpaceHelper {
    public DeviceColorSpaceHelper(PreflightContext _context, PDColorSpace _cs) {
        super(_context, _cs);
    }

    @Override
    protected void processPatternColorSpace(PDColorSpace colorSpace) {
        this.context.addValidationError(new ValidationResult.ValidationError("2.4.9", "Pattern ColorSpace is forbidden"));
    }

    @Override
    protected void processDeviceNColorSpace(PDColorSpace colorSpace) {
        this.context.addValidationError(new ValidationResult.ValidationError("2.4.9", "DeviceN ColorSpace is forbidden"));
    }

    @Override
    protected void processIndexedColorSpace(PDColorSpace colorSpace) {
        PDIndexed indexed = (PDIndexed)colorSpace;
        PDColorSpace baseColorSpace = indexed.getBaseColorSpace();
        ColorSpaces colorSpaces = ColorSpaces.valueOf(baseColorSpace.getName());
        switch (colorSpaces) {
            case Indexed: 
            case Indexed_SHORT: 
            case Pattern: {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.9", colorSpaces.getLabel() + " ColorSpace is forbidden"));
                break;
            }
            default: {
                this.processAllColorSpace(baseColorSpace);
            }
        }
    }
}

