/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.Collections;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.ShadingPatternFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class ShadingPatternFeaturesObject
extends FeaturesObject {
    private static final String ID = "id";

    public ShadingPatternFeaturesObject(ShadingPatternFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.PATTERN;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        ShadingPatternFeaturesObjectAdapter spAdapter = (ShadingPatternFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode("pattern");
        String id = spAdapter.getID();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        root.setAttribute("type", "shading");
        String shadingChild = spAdapter.getShadingChild();
        if (shadingChild != null) {
            FeatureTreeNode shading = root.addChild("shading");
            shading.setAttribute(ID, shadingChild);
        }
        CreateNodeHelper.parseMatrix(spAdapter.getMatrix(), root.addChild("matrix"));
        String extGStateChild = spAdapter.getExtGStateChild();
        if (extGStateChild != null) {
            FeatureTreeNode exGState = root.addChild("graphicsState");
            exGState.setAttribute(ID, extGStateChild);
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        return Collections.emptyList();
    }
}

