/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.impl.pb.external.PBoxICCOutputProfile;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.tools.IDGenerator;

public class PBoxPDOutputIntent
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDOutputIntent {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDOutputIntent.class.getCanonicalName());
    public static final String OUTPUT_INTENT_TYPE = "PDOutputIntent";
    public static final String DEST_PROFILE = "destProfile";
    private final String destOutputProfileIndirect;
    private ICCOutputProfile iccOutputProfile;

    public PBoxPDOutputIntent(PDOutputIntent simplePDObject) {
        super(simplePDObject, OUTPUT_INTENT_TYPE);
        this.destOutputProfileIndirect = PBoxPDOutputIntent.getDestOutputProfileIndirect(simplePDObject);
    }

    private static String getDestOutputProfileIndirect(PDOutputIntent intent) {
        COSDictionary dictionary = (COSDictionary)intent.getCOSObject();
        COSBase item = dictionary.getItem(COSName.DEST_OUTPUT_PROFILE);
        return IDGenerator.generateID(item);
    }

    @Override
    public String getdestOutputProfileIndirect() {
        return this.destOutputProfileIndirect;
    }

    @Override
    public String getS() {
        COSBase dict = this.simplePDObject.getCOSObject();
        if (dict instanceof COSDictionary) {
            return ((COSDictionary)dict).getNameAsString(COSName.S);
        }
        return null;
    }

    @Override
    public String getICCProfileMD5() {
        return null;
    }

    @Override
    public String getOutputConditionIdentifier() {
        PDOutputIntent outInt = (PDOutputIntent)this.simplePDObject;
        return outInt.getOutputConditionIdentifier();
    }

    @Override
    public Boolean getcontainsDestOutputProfileRef() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        return pageObject != null && pageObject instanceof COSDictionary && ((COSDictionary)pageObject).containsKey(COSName.getPDFName("DestOutputProfileRef"));
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "destProfile": {
                return this.getDestProfile();
            }
        }
        return super.getLinkedObjects(link);
    }

    private ICCOutputProfile parseDestProfile() {
        COSStream dest = ((PDOutputIntent)this.simplePDObject).getDestOutputIntent();
        if (dest != null) {
            return new PBoxICCOutputProfile(dest, this.getS());
        }
        return null;
    }

    public String getColorSpace() {
        if (this.iccOutputProfile == null) {
            this.iccOutputProfile = this.parseDestProfile();
        }
        return this.iccOutputProfile != null && "GTS_PDFA1".equals(this.getS()) ? this.iccOutputProfile.getcolorSpace() : null;
    }

    private List<ICCOutputProfile> getDestProfile() {
        if (this.iccOutputProfile == null) {
            this.iccOutputProfile = this.parseDestProfile();
        }
        if (this.iccOutputProfile == null) {
            return Collections.emptyList();
        }
        ArrayList<ICCOutputProfile> profile = new ArrayList<ICCOutputProfile>(1);
        profile.add(this.iccOutputProfile);
        return Collections.unmodifiableList(profile);
    }
}

