/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.features.objects.OutlinesFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBOutlinesFeaturesObjectAdapter
implements OutlinesFeaturesObjectAdapter {
    private PDDocumentOutline outline;

    public PBOutlinesFeaturesObjectAdapter(PDDocumentOutline outline) {
        this.outline = outline;
    }

    @Override
    public List<OutlinesFeaturesObjectAdapter.OutlineFeaturesObjectAdapter> getChildren() {
        if (this.outline != null) {
            ArrayList<PBOutlineFeaturesObjectAdapter> res = new ArrayList<PBOutlineFeaturesObjectAdapter>();
            for (PDOutlineItem item : this.outline.children()) {
                res.add(new PBOutlineFeaturesObjectAdapter(item));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.outline != null;
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private static class PBOutlineFeaturesObjectAdapter
    implements OutlinesFeaturesObjectAdapter.OutlineFeaturesObjectAdapter {
        private PDOutlineItem outline;

        PBOutlineFeaturesObjectAdapter(PDOutlineItem outline) {
            this.outline = outline;
        }

        @Override
        public Integer getKeyNumber() {
            COSObjectKey key;
            COSDictionary dict;
            if (this.outline != null && (dict = this.outline.getCOSObject()) != null && (key = dict.getKey()) != null) {
                return (int)key.getNumber();
            }
            return null;
        }

        @Override
        public String getTitle() {
            if (this.outline != null) {
                return this.outline.getTitle();
            }
            return null;
        }

        @Override
        public double[] getColor() {
            if (this.outline != null) {
                PDColor color = this.outline.getTextColor();
                return PBAdapterHelper.castFloatArrayToDouble(color.getComponents());
            }
            return null;
        }

        @Override
        public boolean isItalic() {
            return this.outline != null && this.outline.isItalic();
        }

        @Override
        public boolean isBold() {
            return this.outline != null && this.outline.isBold();
        }

        @Override
        public List<OutlinesFeaturesObjectAdapter.OutlineFeaturesObjectAdapter> getChildren() {
            if (this.outline != null) {
                ArrayList<PBOutlineFeaturesObjectAdapter> res = new ArrayList<PBOutlineFeaturesObjectAdapter>();
                for (PDOutlineItem item : this.outline.children()) {
                    res.add(new PBOutlineFeaturesObjectAdapter(item));
                }
                return Collections.unmodifiableList(res);
            }
            return Collections.emptyList();
        }
    }
}

