/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.profiles;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.validation.profiles.Variable;

@XmlRootElement(name="variable")
final class VariableImpl
implements Variable {
    private static final VariableImpl DEFAULT = new VariableImpl();
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final String object;
    @XmlElement
    private final String defaultValue;
    @XmlElement
    private final String value;

    private VariableImpl() {
        this("name", "object", "defaultValue", "value");
    }

    private VariableImpl(String name, String object, String defaultValue, String value) {
        this.name = name;
        this.object = object;
        this.defaultValue = defaultValue;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getObject() {
        return this.object;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)obj;
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.value == null ? other.getValue() != null : !this.value.equals(other.getValue())) {
            return false;
        }
        if (this.defaultValue == null ? other.getDefaultValue() != null : !this.defaultValue.equals(other.getDefaultValue())) {
            return false;
        }
        return !(this.object == null ? other.getObject() != null : !this.object.equals(other.getObject()));
    }

    public String toString() {
        return "Variable [name=" + this.name + ", object=" + this.object + ", defaultValue=" + this.defaultValue + ", value=" + this.value + "]";
    }

    static VariableImpl defaultInstance() {
        return DEFAULT;
    }

    static VariableImpl fromValues(String name, String object, String defaultValue, String value) {
        return new VariableImpl(name, object, defaultValue, value);
    }

    static VariableImpl fromVariable(Variable toConvert) {
        return new VariableImpl(toConvert.getName(), toConvert.getObject(), toConvert.getDefaultValue(), toConvert.getValue());
    }

    static class Adapter
    extends XmlAdapter<VariableImpl, Variable> {
        Adapter() {
        }

        public Variable unmarshal(VariableImpl variableImpl) {
            return variableImpl;
        }

        public VariableImpl marshal(Variable variable) {
            return (VariableImpl)variable;
        }
    }
}

