/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.tools;

import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.ColorComponent;
import org.verapdf.features.tools.FeatureTreeNode;

public final class CreateNodeHelper {
    private static final Logger LOGGER = Logger.getLogger(CreateNodeHelper.class.getCanonicalName());
    public static final String ID = "id";
    private static final String LLX = "llx";
    private static final String LLY = "lly";
    private static final String URX = "urx";
    private static final String URY = "ury";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);

    private CreateNodeHelper() {
    }

    private static String getXMLFormat(Calendar calendar) throws DatatypeConfigurationException {
        GregorianCalendar greg = new GregorianCalendar(Locale.US);
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }

    public static FeatureTreeNode createDateNode(String nodeName, FeatureTreeNode parent, Calendar date, FeaturesObject object) throws FeatureParsingException {
        FeatureTreeNode modificationDate = null;
        if (date != null) {
            modificationDate = parent.addChild(nodeName);
            try {
                modificationDate.setValue(CreateNodeHelper.getXMLFormat(date));
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.log(Level.FINE, "DatatypeFactory implementation not available or can't be instantiated", e);
                object.registerNewError(e.getMessage());
            }
        }
        return modificationDate;
    }

    public static FeatureTreeNode addBoxFeature(String name, double[] box, FeatureTreeNode parent) throws FeatureParsingException {
        FeatureTreeNode boxNode = null;
        if (box != null && box.length >= 4) {
            boxNode = parent.addChild(name);
            boxNode.setAttribute(LLX, CreateNodeHelper.formatDouble(box[0], 3));
            boxNode.setAttribute(LLY, CreateNodeHelper.formatDouble(box[1], 3));
            boxNode.setAttribute(URX, CreateNodeHelper.formatDouble(box[2], 3));
            boxNode.setAttribute(URY, CreateNodeHelper.formatDouble(box[3], 3));
        }
        return boxNode;
    }

    public static void addWidthHeightFeatures(double[] box, FeatureTreeNode parent) throws FeatureParsingException {
        if (box != null && box.length >= 4) {
            parent.addChild(WIDTH).setValue(CreateNodeHelper.formatDouble(box[2] - box[0], 3));
            parent.addChild(HEIGHT).setValue(CreateNodeHelper.formatDouble(box[3] - box[1], 3));
        }
    }

    public static FeatureTreeNode addNotEmptyNode(String name, String value, FeatureTreeNode parent) throws FeatureParsingException {
        if (name != null && value != null) {
            FeatureTreeNode node = parent.addChild(name);
            node.setValue(value);
            return node;
        }
        return null;
    }

    public static FeatureTreeNode addDeviceColorSpaceNode(String name, double[] color, FeatureTreeNode parent, FeaturesObject object) throws FeatureParsingException {
        if (name == null || color == null) {
            return null;
        }
        FeatureTreeNode colorNode = parent.addChild(name);
        boolean typeDefined = false;
        for (ColorComponent component : ColorComponent.values()) {
            if (component.getSize() != color.length) continue;
            typeDefined = true;
            colorNode.setAttributes(component.createAttributesMap(color));
        }
        if (!typeDefined) {
            object.registerNewError("Can not define color type");
        }
        return colorNode;
    }

    public static void parseIDSet(Set<String> set, String elementName, String setName, FeatureTreeNode root) throws FeatureParsingException {
        if (set != null && !set.isEmpty()) {
            FeatureTreeNode setNode = setName == null ? root : root.addChild(setName);
            for (String entry : set) {
                if (entry == null) continue;
                FeatureTreeNode entryNode = setNode.addChild(elementName);
                entryNode.setAttribute(ID, entry);
            }
        }
    }

    public static FeatureTreeNode parseMetadata(InputStream metadata, String nodeName, FeatureTreeNode parent, FeaturesObject object) throws FeatureParsingException {
        if (metadata == null) {
            return null;
        }
        FeatureTreeNode node = parent.addMetadataChild(nodeName);
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((r = metadata.read(buffer)) != -1) {
                out.write(buffer, 0, r);
            }
            byte[] bStream = out.toByteArray();
            String hexString = DatatypeConverter.printHexBinary((byte[])bStream);
            node.setValue(hexString);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error while obtaining unfiltered metadata stream", e);
            object.registerNewError(e.getMessage());
        }
        return node;
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }

    public static void parseMatrix(double[] array, FeatureTreeNode parent) throws FeatureParsingException {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                FeatureTreeNode element = parent.addChild("element");
                element.setAttribute("index", String.valueOf(i + 1));
                element.setAttribute("value", CreateNodeHelper.formatDouble(array[i], 3));
            }
        }
    }

    public static String formatDouble(double value, int fractionDigits) {
        numberFormat.setMinimumFractionDigits(fractionDigits);
        numberFormat.setMaximumFractionDigits(fractionDigits);
        return numberFormat.format(value);
    }

    static {
        numberFormat.setGroupingUsed(false);
    }
}

