/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.validation.validators;

import java.util.Objects;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;

@XmlRootElement(name="validatorConfig")
final class ValidatorConfigImpl
implements ValidatorConfig {
    private static final ValidatorConfigImpl defaultConfig = new ValidatorConfigImpl();
    private final String password;
    private PDFAFlavour flavour;
    private PDFAFlavour defaultFlavour;
    @XmlAttribute
    private final boolean recordPasses;
    @XmlAttribute
    private final int maxFails;
    @XmlAttribute
    private final boolean debug;
    @XmlAttribute
    private final boolean showErrorMessages;
    @XmlAttribute
    private final boolean isLogsEnabled;
    @XmlAttribute
    private final String loggingLevel;
    @XmlAttribute
    private final int maxNumberOfDisplayedFailedChecks;
    @XmlAttribute
    private final boolean showProgress;
    private final boolean nonPDFExtension;

    private ValidatorConfigImpl() {
        this(PDFAFlavour.NO_FLAVOUR, false, -1, false, false, Level.WARNING, "", false);
    }

    private ValidatorConfigImpl(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug, boolean isLogsEnabled, Level loggingLevel, String password, boolean showProgress) {
        this(flavour, PDFAFlavour.PDFA_1_B, recordPasses, maxFails, debug, isLogsEnabled, loggingLevel, 100, true, password, showProgress, false);
    }

    private ValidatorConfigImpl(PDFAFlavour flavour, PDFAFlavour defaultFlavour, boolean recordPasses, int maxFails, boolean debug, boolean isLogsEnabled, Level loggingLevel, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, String password, boolean showProgress, boolean nonPDFExtension) {
        this.flavour = flavour;
        this.defaultFlavour = defaultFlavour;
        this.recordPasses = recordPasses;
        this.maxFails = maxFails;
        this.debug = debug;
        this.isLogsEnabled = isLogsEnabled;
        this.loggingLevel = loggingLevel.toString();
        this.maxNumberOfDisplayedFailedChecks = maxNumberOfDisplayedFailedChecks;
        this.showErrorMessages = showErrorMessages;
        this.password = password;
        this.showProgress = showProgress;
        this.nonPDFExtension = nonPDFExtension;
    }

    @Override
    public boolean isRecordPasses() {
        return this.recordPasses;
    }

    @Override
    public int getMaxFails() {
        return this.maxFails;
    }

    @Override
    @XmlAttribute
    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public void setFlavour(PDFAFlavour flavour) {
        this.flavour = flavour;
    }

    @Override
    @XmlAttribute
    public PDFAFlavour getDefaultFlavour() {
        return this.defaultFlavour;
    }

    @Override
    public void setDefaultFlavour(PDFAFlavour defaultFlavour) {
        this.defaultFlavour = defaultFlavour;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isLogsEnabled() {
        return this.isLogsEnabled;
    }

    @Override
    public boolean showErrorMessages() {
        return this.showErrorMessages;
    }

    @Override
    public Level getLoggingLevel() {
        return Level.parse(this.loggingLevel);
    }

    @Override
    public int getMaxNumberOfDisplayedFailedChecks() {
        return this.maxNumberOfDisplayedFailedChecks;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean getShowProgress() {
        return this.showProgress;
    }

    @Override
    public boolean getNonPDFExtension() {
        return this.nonPDFExtension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flavour == null ? 0 : this.flavour.hashCode());
        result = 31 * result + (this.defaultFlavour == null ? 0 : this.defaultFlavour.hashCode());
        result = 31 * result + this.maxFails;
        result = 31 * result + (this.recordPasses ? 1231 : 1237);
        result = 31 * result + (this.debug ? 1231 : 1237);
        result = 31 * result + (this.isLogsEnabled ? 1231 : 1237);
        result = 31 * result + (this.showErrorMessages ? 1231 : 1237);
        result = 31 * result + (this.loggingLevel == null ? 0 : this.loggingLevel.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.maxNumberOfDisplayedFailedChecks;
        result = 31 * result + (this.showProgress ? 1231 : 1237);
        result = 31 * result + (this.nonPDFExtension ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatorConfigImpl)) {
            return false;
        }
        ValidatorConfigImpl other = (ValidatorConfigImpl)obj;
        if (this.flavour != other.flavour) {
            return false;
        }
        if (this.defaultFlavour != other.defaultFlavour) {
            return false;
        }
        if (this.maxFails != other.maxFails) {
            return false;
        }
        if (this.recordPasses != other.recordPasses) {
            return false;
        }
        if (this.maxNumberOfDisplayedFailedChecks != other.maxNumberOfDisplayedFailedChecks) {
            return false;
        }
        if (this.debug != other.debug) {
            return false;
        }
        if (this.showErrorMessages != other.showErrorMessages) {
            return false;
        }
        if (this.isLogsEnabled != other.isLogsEnabled) {
            return false;
        }
        if (!Objects.equals(this.password, other.password)) {
            return false;
        }
        if (this.showProgress != other.showProgress) {
            return false;
        }
        if (this.nonPDFExtension != other.nonPDFExtension) {
            return false;
        }
        return Objects.equals(this.loggingLevel, other.loggingLevel);
    }

    public String toString() {
        return "ValidatorConfigImpl [recordPasses=" + this.recordPasses + ", maxFails=" + this.maxFails + ", flavour=" + (Object)((Object)this.flavour) + "]";
    }

    static ValidatorConfig defaultInstance() {
        return defaultConfig;
    }

    static ValidatorConfig fromValues(PDFAFlavour flavour, boolean recordPasses, int maxFails, boolean debug, boolean isLogsEnabled, Level loggingLevel, String password, boolean showProgress) {
        return new ValidatorConfigImpl(flavour, recordPasses, maxFails, debug, isLogsEnabled, loggingLevel, password, showProgress);
    }

    static ValidatorConfig fromValues(PDFAFlavour flavour, PDFAFlavour defaultFlavour, boolean recordPasses, int maxFails, boolean debug, boolean isLogsEnabled, Level loggingLevel, int maxNumberOfDisplayedFailedChecks, boolean showErrorMessages, String password, boolean showProgress, boolean nonPDFExtension) {
        return new ValidatorConfigImpl(flavour, defaultFlavour, recordPasses, maxFails, debug, isLogsEnabled, loggingLevel, maxNumberOfDisplayedFailedChecks, showErrorMessages, password, showProgress, nonPDFExtension);
    }

    static class Adapter
    extends XmlAdapter<ValidatorConfigImpl, ValidatorConfig> {
        Adapter() {
        }

        public ValidatorConfig unmarshal(ValidatorConfigImpl validationConfigImpl) {
            return validationConfigImpl;
        }

        public ValidatorConfigImpl marshal(ValidatorConfig validationResult) {
            return (ValidatorConfigImpl)validationResult;
        }
    }
}

