/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.features.objects.InteractiveFormFieldFeaturesObjectAdapter;
import org.verapdf.pd.form.PDFormField;

public class GFInteractiveFormFieldFeaturesObjectAdapter
implements InteractiveFormFieldFeaturesObjectAdapter {
    private static final EnumMap<COSObjType, String> valueMap = new EnumMap(COSObjType.class);
    private final PDFormField formField;

    public GFInteractiveFormFieldFeaturesObjectAdapter(PDFormField formField) {
        this.formField = formField;
    }

    public String getFullyQualifiedName() {
        return this.formField.getFullyQualifiedName();
    }

    public String getValue() {
        COSObject value = this.formField.getV();
        if (value == null || value.empty()) {
            return null;
        }
        COSObjType type = value.getType();
        switch (type) {
            case COS_BOOLEAN: {
                return String.valueOf(value.getBoolean());
            }
            case COS_STRING: 
            case COS_NAME: {
                return value.getString();
            }
            case COS_INTEGER: {
                return String.valueOf(value.getInteger());
            }
            case COS_REAL: {
                return String.valueOf(value.getReal());
            }
        }
        return valueMap.getOrDefault(type, null);
    }

    public List<InteractiveFormFieldFeaturesObjectAdapter> getChildren() {
        List childFormFields = this.formField.getChildFormFields();
        if (childFormFields != null && !childFormFields.isEmpty()) {
            ArrayList<InteractiveFormFieldFeaturesObjectAdapter> res = new ArrayList<InteractiveFormFieldFeaturesObjectAdapter>();
            for (PDFormField field : childFormFields) {
                res.add(new GFInteractiveFormFieldFeaturesObjectAdapter(field));
            }
            return res;
        }
        return Collections.emptyList();
    }

    public boolean isPDFObjectPresent() {
        return this.formField != null && !this.formField.empty();
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }

    static {
        valueMap.put(COSObjType.COS_ARRAY, "--COSArray--");
        valueMap.put(COSObjType.COS_DICT, "--COSDictionary--");
        valueMap.put(COSObjType.COS_STREAM, "--COSStream--");
    }
}

