/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSFilters;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class GFLowLvlInfoFeaturesObject
implements IFeaturesObject {
    private COSDocument document;
    private static final Map<ASAtom, ASAtom> filtersAbbreviations;

    public GFLowLvlInfoFeaturesObject(COSDocument document) {
        this.document = document;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.LOW_LEVEL_INFO;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.document != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"lowLevelInfo");
            if (this.document.getObjects() != null) {
                root.addChild("indirectObjectsNumber").setValue(String.valueOf(this.document.getObjects().size()));
            }
            this.addDocumentId(root, collection);
            Set<ASAtom> filters = this.getAllFilters();
            if (!filters.isEmpty()) {
                FeatureTreeNode filtersNode = root.addChild("filters");
                for (ASAtom filter : filters) {
                    if (filter == null) continue;
                    FeatureTreeNode filterNode = filtersNode.addChild("filter");
                    filterNode.setAttribute("name", filter.getValue());
                }
            }
            collection.addNewFeatureTree(FeatureObjectType.LOW_LEVEL_INFO, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private Set<ASAtom> getAllFilters() {
        HashSet<ASAtom> res = new HashSet<ASAtom>();
        for (COSObject base : this.document.getObjects()) {
            if (base.getType() != COSObjType.COS_STREAM) continue;
            COSFilters baseFilters = ((COSStream)base.getDirectBase()).getFilters();
            GFLowLvlInfoFeaturesObject.addFilters(res, baseFilters);
        }
        return res;
    }

    private void addDocumentId(FeatureTreeNode root, FeatureExtractionResult collection) throws FeatureParsingException {
        COSArray ids = this.document.getID();
        if (ids != null) {
            String creationId = ids.at(0).getString();
            String modificationId = ids.at(1).getString();
            FeatureTreeNode documentId = root.addChild("documentId");
            if (creationId != null || modificationId != null) {
                if (creationId != null) {
                    documentId.setAttribute("creationId", creationId);
                }
                if (modificationId != null) {
                    documentId.setAttribute("modificationId", modificationId);
                }
            }
            if (ids.size() != 2 || creationId == null || modificationId == null) {
                ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)documentId, (String)"Document's ID must be an array of two not null elements");
            }
        }
    }

    private static void addFilters(Set<ASAtom> res, COSFilters filters) {
        List atoms = filters.getFilters();
        if (atoms != null) {
            for (ASAtom atom : atoms) {
                if (filtersAbbreviations.keySet().contains(atom)) {
                    atom = filtersAbbreviations.get(atom);
                }
                res.add(atom);
            }
        }
    }

    static {
        HashMap<ASAtom, ASAtom> filtersAbbreviationsTemp = new HashMap<ASAtom, ASAtom>();
        filtersAbbreviationsTemp.put(ASAtom.ASCII_HEX_DECODE_ABBREVIATION, ASAtom.ASCII_HEX_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.ASCII85_DECODE_ABBREVIATION, ASAtom.ASCII85_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.LZW_DECODE_ABBREVIATION, ASAtom.LZW_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.FLATE_DECODE_ABBREVIATION, ASAtom.FLATE_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.RUN_LENGTH_DECODE_ABBREVIATION, ASAtom.RUN_LENGTH_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.CCITTFAX_DECODE_ABBREVIATION, ASAtom.CCITTFAX_DECODE);
        filtersAbbreviationsTemp.put(ASAtom.DCT_DECODE_ABBREVIATION, ASAtom.DCT_DECODE);
        filtersAbbreviations = Collections.unmodifiableMap(filtersAbbreviationsTemp);
    }
}

