/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.EmbeddedFileFeaturesData;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.tools.TypeConverter;

public class GFEmbeddedFileFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(GFEmbeddedFileFeaturesObject.class.getCanonicalName());
    private static final String CREATION_DATE = "creationDate";
    private static final String MOD_DATE = "modDate";
    private COSObject embFile;
    private int index;

    public GFEmbeddedFileFeaturesObject(COSObject embFile, int index) {
        this.embFile = embFile;
        this.index = index;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.EMBEDDED_FILE;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.embFile != null && this.embFile.getType().isDictionaryBased()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"embeddedFile");
            root.setAttribute("id", "file" + this.index);
            GFCreateNodeHelper.addNotEmptyNode("fileName", this.getFilename(), root);
            GFCreateNodeHelper.addNotEmptyNode("description", this.embFile.getStringKey(ASAtom.DESC), root);
            GFCreateNodeHelper.addNotEmptyNode("afRelationship", this.embFile.getStringKey(ASAtom.AF_RELATIONSHIP), root);
            COSObject ef = this.getEmbeddedFile();
            if (ef != null && !ef.empty()) {
                GFCreateNodeHelper.addNotEmptyNode("subtype", ef.getStringKey(ASAtom.SUBTYPE), root);
                GFCreateNodeHelper.addNotEmptyNode("filter", GFEmbeddedFileFeaturesObject.getFilters(ef), root);
                COSObject paramsObj = ef.getKey(ASAtom.PARAMS);
                if (paramsObj != null && !paramsObj.empty()) {
                    Params params = new Params(paramsObj);
                    GFCreateNodeHelper.createDateNode(CREATION_DATE, root, params.getCreationDate(), collection);
                    GFCreateNodeHelper.createDateNode(MOD_DATE, root, params.getModDate(), collection);
                    GFCreateNodeHelper.addNotEmptyNode("checkSum", params.getCheckSum(), root);
                    Long size = params.getSize();
                    if (size != null) {
                        GFCreateNodeHelper.addNotEmptyNode("size", String.valueOf(size), root);
                    }
                }
            }
            collection.addNewFeatureTree(FeatureObjectType.EMBEDDED_FILE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        COSObject ef = this.getEmbeddedFile();
        if (ef == null && !ef.empty()) {
            LOGGER.log(Level.FINE, "Missed embedded file in PDComplexFileSpecification");
            return null;
        }
        EmbeddedFileFeaturesData.Builder builder = new EmbeddedFileFeaturesData.Builder((InputStream)ef.getData(COSStream.FilterFlags.DECODE));
        builder.name(this.getFilename());
        builder.description(this.embFile.getStringKey(ASAtom.DESC));
        builder.afRelationship(this.embFile.getStringKey(ASAtom.AF_RELATIONSHIP));
        builder.subtype(ef.getStringKey(ASAtom.SUBTYPE));
        COSObject paramsObj = ef.getKey(ASAtom.PARAMS);
        if (paramsObj != null && !paramsObj.empty()) {
            Params params = new Params(paramsObj);
            builder.creationDate(params.getCreationDate());
            builder.modDate(params.getModDate());
            builder.checkSum(params.getCheckSum());
            Long size = params.getSize();
            if (size != null) {
                builder.size(Integer.valueOf(size.intValue()));
            }
        }
        return builder.build();
    }

    private static String getFilters(COSObject ef) {
        COSObject filter = ef.getKey(ASAtom.FILTER);
        if (filter != null && !filter.empty()) {
            if (filter.getType() == COSObjType.COS_NAME) {
                return filter.getString();
            }
            if (filter.getType() == COSObjType.COS_ARRAY) {
                StringBuilder builder = new StringBuilder();
                for (COSObject elem : (COSArray)filter.getDirectBase()) {
                    String elemValue = elem.getString();
                    if (elemValue == null) continue;
                    builder.append(elemValue).append(" ");
                }
                return builder.toString().trim();
            }
        }
        return null;
    }

    private String getFilename() {
        String filename = this.embFile.getStringKey(ASAtom.UF);
        if (filename == null) {
            filename = this.embFile.getStringKey(ASAtom.DOS);
        }
        if (filename == null) {
            filename = this.embFile.getStringKey(ASAtom.MAC);
        }
        if (filename == null) {
            filename = this.embFile.getStringKey(ASAtom.UNIX);
        }
        if (filename == null) {
            filename = this.embFile.getStringKey(ASAtom.F);
        }
        return filename;
    }

    private COSObject getEmbeddedFile() {
        COSObject file;
        COSObject efDict;
        if (this.embFile != null && !this.embFile.empty() && (efDict = this.embFile.getKey(ASAtom.EF)) != null && efDict.getType() == COSObjType.COS_DICT && (file = efDict.getKey(ASAtom.F)) != null && file.getType() == COSObjType.COS_STREAM) {
            return file;
        }
        return null;
    }

    private class Params {
        private COSObject obj;

        public Params(COSObject obj) {
            this.obj = obj;
        }

        public Calendar getCreationDate() {
            return this.getDate(ASAtom.CREATION_DATE);
        }

        public Calendar getModDate() {
            return this.getDate(ASAtom.MOD_DATE);
        }

        public String getCheckSum() {
            return this.obj.getStringKey(ASAtom.CHECKSUM);
        }

        public Long getSize() {
            return this.obj.getIntegerKey(ASAtom.SIZE);
        }

        private Calendar getDate(ASAtom type) {
            String date = this.obj.getStringKey(type);
            if (date != null) {
                Calendar dateCal = TypeConverter.parseDate((String)date);
                return dateCal;
            }
            return null;
        }
    }
}

