/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.action;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo3DView;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionHide;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionImportData;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionMovie;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionNOP;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionNamed;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRemoteGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRendition;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionResetForm;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSetOCGState;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSetState;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSound;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSubmitForm;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionThread;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionTrans;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;

public final class PDActionFactory {
    private PDActionFactory() {
    }

    public static PDAction createAction(COSDictionary action) {
        PDAction retval = null;
        if (action != null) {
            String type = action.getNameAsString("S");
            if ("JavaScript".equals(type)) {
                retval = new PDActionJavaScript(action);
            } else if ("GoTo".equals(type)) {
                retval = new PDActionGoTo(action);
            } else if ("Launch".equals(type)) {
                retval = new PDActionLaunch(action);
            } else if ("GoToR".equals(type)) {
                retval = new PDActionRemoteGoTo(action);
            } else if ("URI".equals(type)) {
                retval = new PDActionURI(action);
            } else if ("Named".equals(type)) {
                retval = new PDActionNamed(action);
            } else if ("Sound".equals(type)) {
                retval = new PDActionSound(action);
            } else if ("Movie".equals(type)) {
                retval = new PDActionMovie(action);
            } else if ("ImportData".equals(type)) {
                retval = new PDActionImportData(action);
            } else if ("ResetForm".equals(type)) {
                retval = new PDActionResetForm(action);
            } else if ("GoToR".equals(type)) {
                retval = new PDActionRemoteGoTo(action);
            } else if ("NOP".equals(type)) {
                retval = new PDActionNOP(action);
            } else if ("SetState".equals(type)) {
                retval = new PDActionSetState(action);
            } else if ("Hide".equals(type)) {
                retval = new PDActionHide(action);
            } else if ("SubmitForm".equals(type)) {
                retval = new PDActionSubmitForm(action);
            } else if ("Thread".equals(type)) {
                retval = new PDActionThread(action);
            } else if ("GoTo3DView".equals(type)) {
                retval = new PDActionGoTo3DView(action);
            } else if ("Rendition".equals(type)) {
                retval = new PDActionRendition(action);
            } else if ("SetOCGState".equals(type)) {
                retval = new PDActionSetOCGState(action);
            } else if ("Trans".equals(type)) {
                retval = new PDActionTrans(action);
            }
        }
        return retval;
    }
}

