/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.component;

import java.util.Collection;
import java.util.Formatter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.component.AuditDuration;

@XmlRootElement(name="duration")
public final class AuditDurationImpl
implements AuditDuration {
    private static final AuditDuration defaultInstance = new AuditDurationImpl();
    private static final long msInSec = 1000L;
    private static final int secInMin = 60;
    private static final long msInMin = 60000L;
    private static final int minInHour = 60;
    private static final long msInHour = 3600000L;
    @XmlAttribute
    private final long start;
    @XmlAttribute
    private final long finish;

    private AuditDurationImpl() {
        this(0L, 0L);
    }

    private AuditDurationImpl(long start, long finish) {
        this.start = start;
        this.finish = finish;
        assert (finish >= start);
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getFinish() {
        return this.finish;
    }

    @Override
    public long getDifference() {
        return this.finish - this.start;
    }

    @Override
    @XmlValue
    public String getDuration() {
        return AuditDurationImpl.getStringDuration(this.getDifference());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.finish ^ this.finish >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditDuration)) {
            return false;
        }
        AuditDuration other = (AuditDuration)obj;
        if (this.finish != other.getFinish()) {
            return false;
        }
        return this.start == other.getStart();
    }

    public String toString() {
        return "AuditDurationImpl [start=" + this.start + ", finish=" + this.finish + ", getDifference()=" + this.getDifference() + ", getDuration()=" + this.getDuration() + "]";
    }

    static AuditDuration defaultInstance() {
        return defaultInstance;
    }

    static AuditDuration fromValues(long start, long finish) {
        if (start < 0L || finish < 0L) {
            throw new IllegalArgumentException("Args start:" + start + " and finish:" + finish + " must be >= 0");
        }
        if (start > finish) {
            throw new IllegalArgumentException("Args start" + start + " must be > finish:" + finish);
        }
        return new AuditDurationImpl(start, finish);
    }

    public static String getStringDuration(long difference) {
        String res;
        long diff = difference;
        Long hours = diff / 3600000L;
        Long mins = (diff %= 3600000L) / 60000L;
        Long sec = (diff %= 60000L) / 1000L;
        Long ms = diff %= 1000L;
        try (Formatter formatter = new Formatter();){
            formatter.format("%02d:%02d:%02d:%03d", hours, mins, sec, ms);
            res = formatter.toString();
        }
        return res;
    }

    public static long sumDuration(Collection<AuditDuration> durations) {
        long res = 0L;
        if (durations != null) {
            for (AuditDuration duration : durations) {
                res += duration.getDifference();
            }
        }
        return res;
    }

    static class Adapter
    extends XmlAdapter<AuditDurationImpl, AuditDuration> {
        Adapter() {
        }

        public AuditDuration unmarshal(AuditDurationImpl procResultImpl) {
            return procResultImpl;
        }

        public AuditDurationImpl marshal(AuditDuration procResult) {
            return (AuditDurationImpl)procResult;
        }
    }
}

