/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;

public class FeaturesReporter {
    public static final String CUSTOM_FEATURES_NAME = "customFeatures";
    public static final String PLUGIN_FEATURES_NAME = "pluginFeatures";
    private static Map<FeatureObjectType, List<AbstractFeaturesExtractor>> featuresExtractors = new HashMap<FeatureObjectType, List<AbstractFeaturesExtractor>>();
    private final FeatureExtractionResult collection;
    private final FeatureExtractorConfig config;

    public FeaturesReporter(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        if (extractors == null) {
            throw new IllegalArgumentException(FeaturesReporter.nullMessage("extractors"));
        }
        if (config == null) {
            throw new IllegalArgumentException(FeaturesReporter.nullMessage("config"));
        }
        this.config = config;
        this.collection = new FeatureExtractionResult();
        for (AbstractFeaturesExtractor extractor : extractors) {
            FeaturesReporter.registerFeaturesExtractor(extractor);
        }
    }

    public FeaturesReporter(FeatureExtractorConfig config) {
        this(config, Collections.emptyList());
    }

    static void registerFeaturesExtractor(AbstractFeaturesExtractor extractor) {
        if (featuresExtractors.get((Object)extractor.getType()) == null) {
            featuresExtractors.put(extractor.getType(), new ArrayList());
        }
        featuresExtractors.get((Object)extractor.getType()).add(extractor);
    }

    public void report(IFeaturesObject obj) {
        if (!this.config.isFeatureEnabled(obj.getType())) {
            return;
        }
        try {
            FeaturesData objData;
            FeatureTreeNode root = obj.reportFeatures(this.collection);
            if (featuresExtractors.containsKey((Object)obj.getType()) && (objData = obj.getData()) != null) {
                FeatureTreeNode custom = root.addChild(CUSTOM_FEATURES_NAME);
                for (AbstractFeaturesExtractor ext : featuresExtractors.get((Object)obj.getType())) {
                    List<FeatureTreeNode> cust = ext.getFeatures(objData);
                    if (cust == null || cust.isEmpty()) continue;
                    FeatureTreeNode custRoot = custom.addChild(PLUGIN_FEATURES_NAME);
                    AbstractFeaturesExtractor.ExtractorDetails details = ext.getDetails();
                    if (!details.getName().isEmpty()) {
                        custRoot.setAttribute("name", details.getName());
                    }
                    if (!details.getVersion().isEmpty()) {
                        custRoot.setAttribute("version", details.getVersion());
                    }
                    if (!details.getDescription().isEmpty()) {
                        custRoot.setAttribute("description", details.getDescription());
                    }
                    for (FeatureTreeNode ftn : cust) {
                        if (ftn == null) continue;
                        custRoot.addChild(ftn);
                    }
                }
            }
        }
        catch (FeatureParsingException ignore) {
            throw new IllegalStateException("FeaturesReporter.report() illegal state.", ignore);
        }
    }

    public FeatureExtractionResult getCollection() {
        return this.collection;
    }

    private static String nullMessage(String name) {
        return String.format("Argument %s cannot be null.", name);
    }
}

