/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.features.FeaturesData;

public final class ICCProfileFeaturesData
extends FeaturesData {
    private final InputStream metadata;
    private final Integer n;
    private final List<Double> range;

    private ICCProfileFeaturesData(InputStream metadata, InputStream stream, Integer n, List<Double> range) {
        super(stream);
        this.metadata = metadata;
        this.n = n;
        this.range = range == null ? null : new ArrayList<Double>(range);
    }

    public static ICCProfileFeaturesData newInstance(InputStream metadata, InputStream stream, Integer n, List<Double> range) {
        if (stream == null) {
            throw new IllegalArgumentException("ICCProfile stream can not be null");
        }
        return new ICCProfileFeaturesData(metadata, stream, n, range);
    }

    public InputStream getMetadata() {
        return this.metadata;
    }

    public Integer getN() {
        return this.n;
    }

    public List<Double> getRange() {
        return this.range == null ? null : Collections.unmodifiableList(this.range);
    }
}

