/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBLowLvlInfoFeaturesObject
implements IFeaturesObject {
    private COSDocument document;
    private static final Map<String, String> filtersAbbreviations;

    public PBLowLvlInfoFeaturesObject(COSDocument document) {
        this.document = document;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.LOW_LEVEL_INFO;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.document != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("lowLevelInfo");
            if (this.document.getObjects() != null) {
                root.addChild("indirectObjectsNumber").setValue(String.valueOf(this.document.getObjects().size()));
            }
            this.addDocumentId(root, collection);
            Set<String> filters = this.getAllFilters();
            if (!filters.isEmpty()) {
                FeatureTreeNode filtersNode = root.addChild("filters");
                for (String filter : filters) {
                    if (filter == null) continue;
                    FeatureTreeNode filterNode = filtersNode.addChild("filter");
                    filterNode.setAttribute("name", filter);
                }
            }
            collection.addNewFeatureTree(FeatureObjectType.LOW_LEVEL_INFO, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getAllFilters() {
        HashSet<String> res = new HashSet<String>();
        for (COSBase cOSBase : this.document.getObjects()) {
            void var3_3;
            while (var3_3 instanceof COSObject) {
                COSBase cOSBase2 = ((COSObject)var3_3).getObject();
            }
            if (!(var3_3 instanceof COSStream)) continue;
            try {
                COSStream stream = (COSStream)var3_3;
                Throwable throwable = null;
                try {
                    COSBase baseFilter = stream.getFilters();
                    if (baseFilter == null) continue;
                    PBLowLvlInfoFeaturesObject.addFiltersFromBase(res, baseFilter);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException excep) {
                excep.printStackTrace();
            }
        }
        return res;
    }

    private void addDocumentId(FeatureTreeNode root, FeatureExtractionResult collection) throws FeatureParsingException {
        COSArray ids = this.document.getDocumentID();
        if (ids != null) {
            String creationId = PBCreateNodeHelper.getStringFromBase(ids.get(0));
            String modificationId = PBCreateNodeHelper.getStringFromBase(ids.get(1));
            FeatureTreeNode documentId = root.addChild("documentId");
            if (creationId != null || modificationId != null) {
                if (creationId != null) {
                    documentId.setAttribute("creationId", creationId);
                }
                if (modificationId != null) {
                    documentId.setAttribute("modificationId", modificationId);
                }
            }
            if (ids.size() != 2 || creationId == null || modificationId == null) {
                ErrorsHelper.addErrorIntoCollection(collection, documentId, "Document's ID must be an array of two not null elements");
            }
        }
    }

    private static void addFiltersFromBase(Set<String> res, COSBase base) {
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            if (filtersAbbreviations.keySet().contains(name)) {
                name = filtersAbbreviations.get(name);
            }
            res.add(name);
        } else if (base instanceof COSArray) {
            for (COSBase baseElement : (COSArray)base) {
                if (!(baseElement instanceof COSName)) continue;
                String name = ((COSName)baseElement).getName();
                if (filtersAbbreviations.keySet().contains(name)) {
                    name = filtersAbbreviations.get(name);
                }
                res.add(name);
            }
        }
    }

    static {
        HashMap<String, String> filtersAbbreviationsTemp = new HashMap<String, String>();
        filtersAbbreviationsTemp.put("AHx", "ASCIIHexDecode");
        filtersAbbreviationsTemp.put("A85", "ASCII85Decode");
        filtersAbbreviationsTemp.put("LZW", "LZWDecode");
        filtersAbbreviationsTemp.put("Fl", "FlateDecode");
        filtersAbbreviationsTemp.put("RL", "RunLengthDecode");
        filtersAbbreviationsTemp.put("CCF", "CCITTFaxDecode");
        filtersAbbreviationsTemp.put("DCT", "DCTDecode");
        filtersAbbreviations = Collections.unmodifiableMap(filtersAbbreviationsTemp);
    }
}

