/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBTilingPatternFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDTilingPattern tilingPattern;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public PBTilingPatternFeaturesObject(PDTilingPattern tilingPattern, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.tilingPattern = tilingPattern;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.PATTERN;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.tilingPattern != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("pattern");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.setAttribute("type", "tiling");
            root.addChild("paintType").setValue(String.valueOf(this.tilingPattern.getPaintType()));
            root.addChild("tilingType").setValue(String.valueOf(this.tilingPattern.getTilingType()));
            PBCreateNodeHelper.addBoxFeature("bbox", this.tilingPattern.getBBox(), root);
            root.addChild("xStep").setValue(String.valueOf(this.tilingPattern.getXStep()));
            root.addChild("yStep").setValue(String.valueOf(this.tilingPattern.getYStep()));
            PBCreateNodeHelper.parseFloatMatrix(this.tilingPattern.getMatrix().getValues(), root.addChild("matrix"));
            this.parseResources(root);
            collection.addNewFeatureTree(FeatureObjectType.PATTERN, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

