/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.ASFilterFactory;
import org.verapdf.as.filters.ASInFilter;
import org.verapdf.as.filters.ASOutFilter;
import org.verapdf.as.filters.IASFilterFactory;
import org.verapdf.as.filters.io.ASBufferingInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASOutputStream;
import org.verapdf.cos.COSDictionary;

public class COSFilterRegistry {
    private static Map<ASAtom, IASFilterFactory> registeredFactories;
    private static final Logger LOGGER;

    private COSFilterRegistry() {
    }

    private static IASFilterFactory factoryByName(ASAtom name) {
        return registeredFactories.get(name);
    }

    public static void registerFactory(ASAtom filterName, IASFilterFactory factory) throws Exception {
        if (registeredFactories.containsKey(filterName)) {
            throw new Exception("COSFilterRegistry::RegisterFactory(...)internal library error");
        }
        registeredFactories.put(filterName, factory);
    }

    public static ASInFilter getDecodeFilter(ASAtom filterName, ASInputStream inputStream, COSDictionary decodeParams) throws IOException {
        IASFilterFactory filterFactory = COSFilterRegistry.factoryByName(filterName);
        if (filterFactory != null) {
            return filterFactory.getInFilter(inputStream, decodeParams);
        }
        LOGGER.log(Level.FINE, "Trying to use unimplemented decoding filter.");
        return new ASBufferingInFilter(inputStream);
    }

    public static ASOutFilter getEncodeFilter(ASAtom filterName, ASOutputStream outputStream) throws IOException {
        IASFilterFactory filterFactory = COSFilterRegistry.factoryByName(filterName);
        if (filterFactory != null) {
            return filterFactory.getOutFilter(outputStream);
        }
        return null;
    }

    static {
        LOGGER = Logger.getLogger(COSFilterRegistry.class.getCanonicalName());
        registeredFactories = new HashMap<ASAtom, IASFilterFactory>();
        try {
            COSFilterRegistry.registerFactory(ASAtom.FLATE_DECODE, new ASFilterFactory(ASAtom.FLATE_DECODE));
            COSFilterRegistry.registerFactory(ASAtom.ASCII_HEX_DECODE, new ASFilterFactory(ASAtom.ASCII_HEX_DECODE));
            COSFilterRegistry.registerFactory(ASAtom.ASCII85_DECODE, new ASFilterFactory(ASAtom.ASCII85_DECODE));
            COSFilterRegistry.registerFactory(ASAtom.LZW_DECODE, new ASFilterFactory(ASAtom.LZW_DECODE));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Trying to register factory twice", e);
        }
    }
}

