/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.MetadataFeaturesData;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDMetadata;

public class GFMetadataFeaturesObject
implements IFeaturesObject {
    private PDMetadata metadata;

    public GFMetadataFeaturesObject(PDMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.METADATA;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.metadata != null && !this.metadata.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("metadata");
            GFCreateNodeHelper.parseMetadata(this.metadata, "xmpPackage", root, collection);
            collection.addNewFeatureTree(FeatureObjectType.METADATA, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        if (this.metadata != null && !this.metadata.empty()) {
            InputStream meta = this.metadata.getStream();
            return MetadataFeaturesData.newInstance(meta);
        }
        return null;
    }
}

