/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.ColorComponent;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDOutlineDictionary;
import org.verapdf.pd.PDOutlineItem;

public class GFOutlinesFeaturesObject
implements IFeaturesObject {
    private PDOutlineDictionary outline;

    public GFOutlinesFeaturesObject(PDOutlineDictionary outline) {
        this.outline = outline;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.OUTLINES;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.outline != null && !this.outline.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("outlines");
            HashSet<PDOutlineItem> items = new HashSet<PDOutlineItem>();
            for (PDOutlineItem item : GFOutlinesFeaturesObject.getChildren(this.outline)) {
                if (items.contains(item)) continue;
                GFOutlinesFeaturesObject.createItem(item, root, collection, items);
            }
            collection.addNewFeatureTree(FeatureObjectType.OUTLINES, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private static void createItem(PDOutlineItem item, FeatureTreeNode root, FeatureExtractionResult collection, Set<PDOutlineItem> items) throws FeatureParsingException {
        if (item != null && !item.empty()) {
            items.add(item);
            FeatureTreeNode itemNode = root.addChild("outline");
            GFCreateNodeHelper.addNotEmptyNode("title", item.getTitle(), itemNode);
            FeatureTreeNode color = itemNode.addChild("color");
            double[] clr = item.getColor();
            if (clr != null) {
                color.setAttributes(ColorComponent.RGB_COMPONENTS.createAttributesMap(clr));
            } else {
                ErrorsHelper.addErrorIntoCollection(collection, color, "Color must be in rgb form");
            }
            FeatureTreeNode style = itemNode.addChild("style");
            style.setAttribute("italic", String.valueOf(item.isItalic()));
            style.setAttribute("bold", String.valueOf(item.isBold()));
            for (PDOutlineItem child : GFOutlinesFeaturesObject.getChildren(item)) {
                if (items.contains(child)) continue;
                GFOutlinesFeaturesObject.createItem(child, itemNode, collection, items);
            }
        }
    }

    public static List<PDOutlineItem> getChildren(PDOutlineDictionary dictionary) {
        ArrayList<PDOutlineItem> res = new ArrayList<PDOutlineItem>();
        for (PDOutlineItem curr = dictionary.getFirst(); curr != null; curr = curr.getNext()) {
            res.add(curr);
        }
        return res;
    }
}

