/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDPage;

public class GFPageFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDPage page;
    private String thumb;
    private Set<String> annotsId;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private int index;

    public GFPageFeaturesObject(PDPage page, String thumb, Set<String> annotsId, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild, int index) {
        this.page = page;
        this.thumb = thumb;
        this.annotsId = annotsId;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.index = index;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.PAGE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.page != null && !this.page.empty()) {
            Double scaling;
            FeatureTreeNode root = FeatureTreeNode.createRootNode("page");
            root.setAttribute("orderNumber", Integer.toString(this.index));
            GFCreateNodeHelper.addBoxFeature("mediaBox", this.page.getMediaBox(), root);
            GFCreateNodeHelper.addBoxFeature("cropBox", this.page.getCropBox(), root);
            GFCreateNodeHelper.addBoxFeature("trimBox", this.page.getTrimBox(), root);
            GFCreateNodeHelper.addBoxFeature("bleedBox", this.page.getBleedBox(), root);
            GFCreateNodeHelper.addBoxFeature("artBox", this.page.getArtBox(), root);
            Long rotation = this.page.getRotation();
            if (rotation != null) {
                root.addChild("rotation").setValue(String.valueOf(rotation));
            }
            if ((scaling = this.page.getScaling()) != null) {
                root.addChild("scaling").setValue(String.valueOf(scaling));
            }
            if (this.thumb != null) {
                FeatureTreeNode thumbNode = root.addChild("thumbnail");
                thumbNode.setAttribute(ID, this.thumb);
            }
            GFCreateNodeHelper.parseMetadata(this.page.getMetadata(), "metadata", root, collection);
            GFCreateNodeHelper.parseIDSet(this.annotsId, "annotation", "annotations", root);
            this.parseResources(root);
            collection.addNewFeatureTree(FeatureObjectType.PAGE, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            GFCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            GFCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            GFCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            GFCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            GFCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            GFCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            GFCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

