/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.ByteArrayInputStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSString;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.SignatureFeaturesData;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDSignature;

public class GFSignatureFeaturesObject
implements IFeaturesObject {
    private PDSignature signature;

    public GFSignatureFeaturesObject(PDSignature signature) {
        this.signature = signature;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.SIGNATURE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult featureExtractionResult) throws FeatureParsingException {
        if (this.signature != null && !this.signature.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode("signature");
            GFCreateNodeHelper.addNotEmptyNode("filter", this.signature.getFilter(), root);
            GFCreateNodeHelper.addNotEmptyNode("subFilter", this.signature.getSubfilter(), root);
            COSString contents = this.signature.getContents();
            if (contents != null) {
                GFCreateNodeHelper.addNotEmptyNode("contents", contents.getHexString(), root);
            }
            GFCreateNodeHelper.addNotEmptyNode("name", this.signature.getName(), root);
            GFCreateNodeHelper.createDateNode("signDate", root, this.signature.getSignDate(), featureExtractionResult);
            GFCreateNodeHelper.addNotEmptyNode("location", this.signature.getLocation(), root);
            GFCreateNodeHelper.addNotEmptyNode("reason", this.signature.getReason(), root);
            GFCreateNodeHelper.addNotEmptyNode("contactInfo", this.signature.getContactInfo(), root);
            featureExtractionResult.addNewFeatureTree(FeatureObjectType.SIGNATURE, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        COSString contents = this.signature.getContents();
        ByteArrayInputStream stream = contents == null ? null : new ByteArrayInputStream(contents.get());
        return SignatureFeaturesData.newInstance(stream, GFCreateNodeHelper.getStringFromASAtom(this.signature.getFilter()), GFCreateNodeHelper.getStringFromASAtom(this.signature.getSubfilter()), this.signature.getName(), this.signature.getSignDate(), this.signature.getLocation(), this.signature.getReason(), this.signature.getContactInfo());
    }
}

