/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.JAXBException;
import org.verapdf.apps.Applications;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.gui.LogoPanel;
import org.verapdf.gui.ValidateWorker;
import org.verapdf.gui.tools.GUIConstants;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.pdfa.validation.validators.ValidatorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.reports.BatchSummary;

class CheckerPanel
extends JPanel {
    private static transient ConfigManager config;
    private static final long serialVersionUID = 1290058869994329766L;
    static final Logger logger;
    private static final Map<String, PDFAFlavour> FLAVOURS_MAP;
    private JFileChooser pdfChooser;
    private JFileChooser xmlChooser;
    private JFileChooser htmlChooser;
    private JFileChooser policyChooser;
    private List<File> pdfFile;
    private JTextField chosenPDF;
    private JTextField chosenProfile;
    private JTextField chosenPolicy;
    private JLabel resultLabel;
    private File xmlReport;
    private File htmlReport;
    private File policy;
    private JComboBox<ProcessType> ProcessTypes;
    private JCheckBox fixMetadata;
    private JComboBox<String> chooseFlavour;
    private boolean isValidationErrorOccurred;
    private JButton execute;
    private JButton saveXML;
    private JButton viewXML;
    private JButton saveHTML;
    private JButton viewHTML;
    private transient Path profilePath;
    JProgressBar progressBar;
    transient ValidateWorker validateWorker;

    CheckerPanel(ConfigManager config) throws IOException {
        CheckerPanel.config = config;
        this.profilePath = FileSystems.getDefault().getPath("", new String[0]);
        this.setPreferredSize(new Dimension(450, 200));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.chosenPDF = new JTextField("PDF file not chosen");
        this.chosenPDF.setEditable(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 0, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenPDF, gbc);
        this.add(this.chosenPDF);
        JButton choosePDF = new JButton("Choose PDF");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 0, 0, 1, 1, 1, 2);
        gbl.setConstraints(choosePDF, gbc);
        this.add(choosePDF);
        JLabel processType = new JLabel(" Report type: ");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(processType, gbc);
        this.add(processType);
        this.ProcessTypes = new JComboBox<ProcessType>(ProcessType.getOptionValues());
        this.ProcessTypes.setSelectedItem((Object)config.getApplicationConfig().getProcessType());
        ProcessingTypeRenderer processingTypeRenderer = new ProcessingTypeRenderer();
        this.ProcessTypes.setRenderer(processingTypeRenderer);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 1, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.ProcessTypes, gbc);
        this.add(this.ProcessTypes);
        this.fixMetadata = new JCheckBox("Fix metadata");
        this.fixMetadata.setSelected(config.createProcessorConfig().getTasks().contains((Object)TaskType.FIX_METADATA));
        CheckerPanel.setGridBagConstraintsParameters(gbc, 2, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.fixMetadata, gbc);
        this.add(this.fixMetadata);
        if (config.getApplicationConfig().getProcessType() == ProcessType.EXTRACT) {
            this.fixMetadata.setEnabled(false);
        }
        Vector<String> availableFlavours = new Vector<String>();
        availableFlavours.add("Custom profile");
        availableFlavours.add("Auto-detection");
        for (PDFAFlavour flavour : PDFAFlavour.values()) {
            Set<PDFAFlavour> currentFlavours = Profiles.getVeraProfileDirectory().getPDFAFlavours();
            if (!currentFlavours.contains((Object)flavour)) continue;
            String flavourReadableText = this.getFlavourReadableText(flavour);
            availableFlavours.add(flavourReadableText);
            FLAVOURS_MAP.put(flavourReadableText, flavour);
        }
        this.chooseFlavour = new JComboBox(availableFlavours);
        this.chooseFlavour.setOpaque(true);
        ChooseFlavourRenderer renderer = new ChooseFlavourRenderer();
        this.chooseFlavour.setRenderer(renderer);
        PDFAFlavour fromConfig = config.createProcessorConfig().getValidatorConfig().getFlavour();
        String fromConfigFlavourText = this.getFlavourReadableText(fromConfig);
        if (availableFlavours.contains(fromConfigFlavourText)) {
            this.chooseFlavour.setSelectedItem(fromConfigFlavourText);
        } else {
            this.chooseFlavour.setSelectedItem("Auto-detection");
        }
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 3, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.chooseFlavour, gbc);
        this.add(this.chooseFlavour);
        this.chosenProfile = new JTextField("Validation profile not chosen");
        this.chosenProfile.setEditable(false);
        this.chosenProfile.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 1, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenProfile, gbc);
        this.add(this.chosenProfile);
        if (!this.profilePath.toString().equals("")) {
            this.chosenProfile.setText(this.profilePath.toString());
        } else {
            this.chosenProfile.setText("Please, specify validation profile");
        }
        final JButton chooseProfile = new JButton("Choose Profile");
        chooseProfile.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 1, 0, 1, 1, 1, 2);
        gbl.setConstraints(chooseProfile, gbc);
        this.add(chooseProfile);
        String policy = config.getApplicationConfig().getPolicyFile();
        if (policy == null || policy.isEmpty()) {
            policy = "Policy file not chosen";
        }
        this.chosenPolicy = new JTextField(policy);
        this.chosenPolicy.setEditable(false);
        this.chosenPolicy.setEnabled(this.ProcessTypes.getSelectedItem() == ProcessType.POLICY);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 2, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenPolicy, gbc);
        this.add(this.chosenPolicy);
        final JButton choosePolicy = new JButton("Choose Policy");
        choosePolicy.setEnabled(this.ProcessTypes.getSelectedItem() == ProcessType.POLICY);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(choosePolicy, gbc);
        this.add(choosePolicy);
        this.resultLabel = new JLabel();
        this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
        this.resultLabel.setHorizontalTextPosition(0);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 4, 3, 1, 3, 1, 10);
        gbl.setConstraints(this.resultLabel, gbc);
        this.add(this.resultLabel);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 4, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.progressBar, gbc);
        this.add(this.progressBar);
        this.execute = new JButton("Execute");
        this.execute.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 4, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.execute, gbc);
        this.add(this.execute);
        JPanel reports = new JPanel();
        reports.setBorder(BorderFactory.createTitledBorder("Report"));
        reports.setLayout(new GridLayout(2, 3));
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 5, 4, 3, 4, 1, 2);
        gbl.setConstraints(reports, gbc);
        this.add(reports);
        LogoPanel xmlLogo = new LogoPanel("org/verapdf/gui/images/xml-logo.png", reports.getBackground(), 4);
        reports.add(xmlLogo);
        this.saveXML = new JButton("Save XML");
        this.saveXML.setEnabled(false);
        reports.add(this.saveXML);
        this.viewXML = new JButton("View XML");
        this.viewXML.setEnabled(false);
        reports.add(this.viewXML);
        LogoPanel htmlLogo = new LogoPanel("org/verapdf/gui/images/html-logo.png", reports.getBackground(), 4);
        reports.add(htmlLogo);
        this.saveHTML = new JButton("Save HTML");
        this.saveHTML.setEnabled(false);
        gbc.fill = 2;
        reports.add(this.saveHTML);
        this.viewHTML = new JButton("View HTML");
        this.viewHTML.setEnabled(false);
        reports.add(this.viewHTML);
        this.pdfChooser = CheckerPanel.getChooser("pdf");
        this.pdfChooser.setMultiSelectionEnabled(true);
        this.pdfChooser.setFileSelectionMode(2);
        this.xmlChooser = CheckerPanel.getChooser("xml");
        this.htmlChooser = CheckerPanel.getChooser("html");
        this.policyChooser = CheckerPanel.getChooser("sch", "xsl", "xslt");
        choosePDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.pdfChooser, new String[]{"pdf"});
            }
        });
        this.ProcessTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessType item = (ProcessType)((Object)CheckerPanel.this.ProcessTypes.getSelectedItem());
                switch (item) {
                    case VALIDATE: {
                        this.updateEnabling(true, false);
                        break;
                    }
                    case EXTRACT: {
                        CheckerPanel.this.fixMetadata.setSelected(false);
                        this.updateEnabling(false, false);
                        break;
                    }
                    case VALIDATE_EXTRACT: {
                        this.updateEnabling(true, false);
                        break;
                    }
                    case POLICY: {
                        this.updateEnabling(true, true);
                        break;
                    }
                }
            }

            private void updateEnabling(boolean fixMetadata, boolean policy) {
                CheckerPanel.this.fixMetadata.setEnabled(fixMetadata);
                CheckerPanel.this.chosenPolicy.setEnabled(policy);
                choosePolicy.setEnabled(policy);
                CheckerPanel.this.execute.setEnabled(CheckerPanel.this.isExecute());
            }
        });
        this.chooseFlavour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CheckerPanel.this.chooseFlavour.getSelectedItem().equals("Custom profile")) {
                    chooseProfile.setEnabled(true);
                    CheckerPanel.this.chosenProfile.setEnabled(true);
                } else {
                    chooseProfile.setEnabled(false);
                    CheckerPanel.this.chosenProfile.setEnabled(false);
                }
                CheckerPanel.this.execute.setEnabled(CheckerPanel.this.isExecute());
            }
        });
        chooseProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.xmlChooser, new String[]{"xml"});
            }
        });
        choosePolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.policyChooser, new String[]{"sch", "xsl", "xslt"});
            }
        });
        this.execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CheckerPanel.this.changeConfig();
                    ValidationProfile customProfile = null;
                    if (CheckerPanel.this.chooseFlavour.getSelectedItem().equals("Custom profile")) {
                        customProfile = Profiles.profileFromXml(new FileInputStream(CheckerPanel.this.profilePath.toFile()));
                    }
                    CheckerPanel.this.validateWorker = new ValidateWorker(CheckerPanel.this, CheckerPanel.this.pdfFile, config, customProfile, CheckerPanel.this.policy);
                    CheckerPanel.this.progressBar.setVisible(true);
                    CheckerPanel.this.resultLabel.setVisible(false);
                    CheckerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    CheckerPanel.this.execute.setEnabled(false);
                    CheckerPanel.this.isValidationErrorOccurred = false;
                    CheckerPanel.this.viewXML.setEnabled(false);
                    CheckerPanel.this.saveXML.setEnabled(false);
                    CheckerPanel.this.viewHTML.setEnabled(false);
                    CheckerPanel.this.saveHTML.setEnabled(false);
                    CheckerPanel.this.validateWorker.execute();
                }
                catch (IOException | IllegalArgumentException | JAXBException excep) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, excep.getMessage(), "Error", 0);
                    logger.log(Level.SEVERE, excep.getMessage(), excep);
                }
            }
        });
        this.saveXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.xmlChooser, "xml", CheckerPanel.this.xmlReport);
            }
        });
        this.saveHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.htmlChooser, "html", CheckerPanel.this.htmlReport);
            }
        });
        this.viewXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.xmlReport == null) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "XML report hasn't been saved.", "Error", 0);
                } else {
                    this.openXMLReport();
                }
            }

            private void openXMLReport() {
                try {
                    Desktop.getDesktop().open(CheckerPanel.this.xmlReport);
                }
                catch (IOException excep) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "Some error in opening the XML report.", "Error", 0);
                    logger.log(Level.SEVERE, "Exception in opening the XML report", excep);
                }
            }
        });
        this.viewHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.htmlReport == null) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "HTML report hasn't been saved.", "Error", 0);
                } else {
                    try {
                        Desktop.getDesktop().open(CheckerPanel.this.htmlReport);
                    }
                    catch (IOException excep) {
                        JOptionPane.showMessageDialog(CheckerPanel.this, "Some error in opening the HTML report.", "Error", 0);
                        logger.log(Level.SEVERE, "Exception in opening the HTML report", excep);
                    }
                }
            }
        });
    }

    void validationEnded(File xmlReport, File htmlReport) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.execute.setEnabled(true);
        if (!this.isValidationErrorOccurred) {
            try {
                BatchSummary result = (BatchSummary)this.validateWorker.get();
                if (result.getJobs() == 1) {
                    if (result.getFailedJobs() == 1) {
                        this.setResultMessage("Failed to parse pdf document.", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getValidPdfaCount() > 0) {
                        this.setResultMessage("PDF file is compliant with Validation Profile requirements", GUIConstants.VALIDATION_SUCCESS_COLOR);
                    } else if (result.getInvalidPdfaCount() > 0) {
                        this.setResultMessage("PDF file is not compliant with Validation Profile requirements", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getValidationExceptionCount() == 1) {
                        this.setResultMessage("Could not finish validation due to unexpected error.", GUIConstants.VALIDATION_FAILED_COLOR);
                    } else if (result.getFeatureCount() > 0) {
                        this.setResultMessage("Features report generated", GUIConstants.VALIDATION_SUCCESS_COLOR);
                    } else {
                        this.setResultMessage("Could not finish features collecting due to unexpected error.", GUIConstants.VALIDATION_FAILED_COLOR);
                    }
                } else {
                    this.setResultMessage(this.getBatchResultMessage(result), GUIConstants.BEFORE_VALIDATION_COLOR);
                }
                this.resultLabel.setVisible(true);
                this.xmlReport = xmlReport;
                this.htmlReport = htmlReport;
                if (xmlReport != null) {
                    this.saveXML.setEnabled(true);
                    this.viewXML.setEnabled(true);
                }
                if (htmlReport != null) {
                    this.saveHTML.setEnabled(true);
                    this.viewHTML.setEnabled(true);
                }
            }
            catch (InterruptedException e) {
                this.errorInValidatingOccur("Process has been interrupted: ", e);
            }
            catch (ExecutionException e) {
                this.errorInValidatingOccur("Execution exception in processing: ", e);
            }
        }
    }

    private String getBatchResultMessage(BatchSummary result) {
        String divisor = ",  ";
        String start = "Items processed: " + result.getJobs();
        String end = divisor + "Parsing Error: " + result.getFailedJobs();
        if (result.getValidPdfaCount() + result.getInvalidPdfaCount() + result.getValidationExceptionCount() > 0) {
            end = divisor + "Valid: " + result.getValidPdfaCount() + divisor + "Invalid: " + result.getInvalidPdfaCount() + divisor + "Error: " + (result.getValidationExceptionCount() + result.getFailedJobs());
        } else if (result.getFeatureCount() > 0) {
            end = divisor + "Features generated: " + result.getFeatureCount() + end;
        }
        return start + end;
    }

    private void setResultMessage(String message, Color color) {
        this.resultLabel.setForeground(color);
        this.resultLabel.setText(message);
    }

    void errorInValidatingOccur(String message, Throwable e) {
        logger.log(Level.SEVERE, message, e);
        e.printStackTrace();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.isValidationErrorOccurred = true;
        JOptionPane.showMessageDialog(this, message + e.getMessage(), "Error", 0);
        this.resultLabel.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
        this.resultLabel.setText(message + e.getMessage());
        this.resultLabel.setVisible(true);
    }

    private static JFileChooser getChooser(String ... types) throws IOException {
        JFileChooser res = new JFileChooser();
        File currentDir = new File(new File(".").getCanonicalPath());
        res.setCurrentDirectory(currentDir);
        res.setAcceptAllFileFilterUsed(false);
        res.setFileFilter(new FileNameExtensionFilter(CheckerPanel.elementsDevidedByComa(types), types));
        return res;
    }

    private static String elementsDevidedByComa(String ... elements) {
        StringBuilder description = new StringBuilder(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            description.append(",").append(elements[i]);
        }
        return description.toString();
    }

    private static void setGridBagConstraintsParameters(GridBagConstraints gbc, int gridx, int gridy, int weightx, int weighty, int gridwidth, int gridheight, int fill) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
    }

    private void chooseFile(JFileChooser chooser, String ... extensions) {
        int resultChoose = chooser.showOpenDialog(this);
        if (resultChoose == 0) {
            File[] selectedFiles = chooser.getSelectedFiles();
            if (selectedFiles == null || selectedFiles.length == 0) {
                selectedFiles = new File[]{chooser.getSelectedFile()};
            }
            if (!this.areAllExists(selectedFiles)) {
                JOptionPane.showMessageDialog(this, "Error. Some selected file doesn't exist.", "Error", 0);
            } else if (!this.areAllExtensionsRight(selectedFiles, extensions)) {
                JOptionPane.showMessageDialog(this, "Error. Some selected file is not in " + CheckerPanel.elementsDevidedByComa(extensions) + " format.", "Error", 0);
            } else {
                this.resultLabel.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
                this.resultLabel.setText("");
                this.xmlReport = null;
                this.htmlReport = null;
                this.saveXML.setEnabled(false);
                this.viewXML.setEnabled(false);
                this.saveHTML.setEnabled(false);
                this.viewHTML.setEnabled(false);
                switch (extensions[0]) {
                    case "pdf": {
                        this.pdfFile = this.getAllPDFFiles(selectedFiles);
                        this.chosenPDF.setText(this.getSelectedPathsMessage(selectedFiles));
                        break;
                    }
                    case "xml": {
                        if (selectedFiles.length == 1) {
                            this.profilePath = selectedFiles[0].toPath().toAbsolutePath();
                            this.chosenProfile.setText(this.profilePath.toString());
                            break;
                        }
                        JOptionPane.showMessageDialog(this, "Error. Can't be selected more than one validation profile", "Error", 0);
                        break;
                    }
                    case "sch": 
                    case "xsl": 
                    case "xslt": {
                        if (selectedFiles.length == 1) {
                            this.policy = selectedFiles[0];
                            this.chosenPolicy.setText(this.policy.getAbsolutePath());
                            break;
                        }
                        JOptionPane.showMessageDialog(this, "Error. Can't be selected more than one policy file", "Error", 0);
                        break;
                    }
                }
                this.execute.setEnabled(this.isExecute());
            }
        }
    }

    private List<File> getAllPDFFiles(File[] selectedFiles) {
        if (selectedFiles != null) {
            ArrayList<File> res = new ArrayList<File>();
            this.addAllPDFFiles(selectedFiles, res);
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private void addAllPDFFiles(File[] listOfFiles, List<File> res) {
        for (int i = 0; i < listOfFiles.length; ++i) {
            File file = listOfFiles[i];
            if (file.isFile() && file.getName().toLowerCase().endsWith("." + "pdf".toLowerCase())) {
                res.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.addAllPDFFiles(file.listFiles(), res);
        }
    }

    private boolean areAllExists(File[] files) {
        if (files == null || files.length == 0) {
            return false;
        }
        for (File file : files) {
            if (file != null && file.exists()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllExtensionsRight(File[] files, String ... extensions) {
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                boolean isWrongFile = true;
                for (String extension : extensions) {
                    if (!file.getName().toLowerCase().endsWith("." + extension.toLowerCase())) continue;
                    isWrongFile = false;
                }
                if (!isWrongFile) continue;
                return false;
            }
        }
        return true;
    }

    private String getSelectedPathsMessage(File[] files) {
        if (files != null && files.length > 0) {
            StringBuilder builder = new StringBuilder(files[0].getAbsolutePath());
            for (int i = 1; i < files.length; ++i) {
                builder.append(", ").append(files[i].getAbsolutePath());
            }
            return builder.toString();
        }
        return "";
    }

    private void saveReport(JFileChooser chooser, String extension, File report) {
        if (report == null) {
            JOptionPane.showMessageDialog(this, "Validation hasn't been run.", "Error", 0);
        } else {
            chooser.setSelectedFile(new File(extension.toLowerCase() + "Report." + extension.toLowerCase()));
            int resultChoose = chooser.showSaveDialog(this);
            if (resultChoose == 0) {
                File temp = chooser.getSelectedFile();
                if (!temp.getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
                    temp = new File(temp.getPath() + "." + extension.toLowerCase());
                }
                try {
                    try {
                        Files.copy(report.toPath(), temp.toPath(), new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException excep) {
                        logger.log(Level.FINE, "File already exists, conform overwrite with user", excep);
                        int resultOption = JOptionPane.showConfirmDialog(this, extension.toUpperCase() + " file with the same name already exists. Do you want to overwrite it?", "", 0);
                        if (resultOption == 0) {
                            Files.copy(report.toPath(), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                catch (IOException excep) {
                    JOptionPane.showMessageDialog(this, "Some error in saving the HTML report: " + excep.getMessage(), "Error", 0);
                    logger.log(Level.SEVERE, "Exception saving " + extension.toUpperCase() + " report", excep);
                }
            }
        }
    }

    private void changeConfig() throws JAXBException, IOException {
        if (!this.chooseFlavour.getSelectedItem().equals("Custom profile")) {
            this.profilePath = FileSystems.getDefault().getPath("", new String[0]);
        }
        PDFAFlavour flavour = this.getCurrentFlavour();
        ValidatorConfig validatorConfig = config.getValidatorConfig();
        ValidatorConfig currentConfig = ValidatorFactory.createConfig(flavour, validatorConfig.isRecordPasses(), validatorConfig.getMaxFails());
        config.updateValidatorConfig(currentConfig);
        config.updateAppConfig(this.appConfigFromState());
    }

    VeraAppConfig appConfigFromState() {
        Applications.Builder builder = Applications.createConfigBuilder(config.getApplicationConfig());
        ProcessType selectedItem = (ProcessType)((Object)this.ProcessTypes.getSelectedItem());
        if (this.isFixMetadata()) {
            selectedItem = ProcessType.addProcess(selectedItem, ProcessType.FIX);
        }
        builder.type(selectedItem);
        return builder.build();
    }

    private PDFAFlavour getCurrentFlavour() {
        String selectedItem = (String)this.chooseFlavour.getSelectedItem();
        PDFAFlavour flavour = FLAVOURS_MAP.get(selectedItem);
        return flavour == null ? PDFAFlavour.NO_FLAVOUR : flavour;
    }

    private boolean isExecute() {
        return !(this.pdfFile == null || this.profilePath.toString().equals("") && this.chooseFlavour.getSelectedItem().equals("Custom profile") || this.ProcessTypes.getSelectedItem() == ProcessType.POLICY && this.policy == null);
    }

    boolean isFixMetadata() {
        return this.fixMetadata.isSelected();
    }

    private String getFlavourReadableText(PDFAFlavour flavour) {
        if (flavour.toString().matches("\\d\\w")) {
            String valueString = flavour.toString();
            String parsedFlavour = "PDF/A-";
            parsedFlavour = parsedFlavour + valueString.charAt(0);
            parsedFlavour = parsedFlavour + valueString.substring(1, 2).toUpperCase();
            return parsedFlavour;
        }
        return "Error in parsing flavour";
    }

    static {
        logger = Logger.getLogger(CheckerPanel.class.getCanonicalName());
        FLAVOURS_MAP = new HashMap<String, PDFAFlavour>();
    }

    private class ProcessingTypeRenderer
    extends JLabel
    implements ListCellRenderer<ProcessType> {
        private static final long serialVersionUID = -2841316639915833315L;

        public ProcessingTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ProcessType> list, ProcessType value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.getValue());
            return this;
        }
    }

    private class ChooseFlavourRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private static final long serialVersionUID = 3740801661593829099L;

        public ChooseFlavourRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value);
            return this;
        }
    }
}

