/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.transform.TransformerException;
import org.verapdf.apps.ConfigManager;
import org.verapdf.apps.ProcessType;
import org.verapdf.apps.VeraAppConfig;
import org.verapdf.core.VeraPDFException;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.policy.PolicyChecker;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorFactory;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.HTMLReport;

class ValidateWorker
extends SwingWorker<BatchSummary, Integer> {
    private static final Logger logger = Logger.getLogger(ValidateWorker.class.getCanonicalName());
    private static final String ERROR_IN_OPEN_STREAMS = "Can't open stream from PDF file or can't open stream to temporary XML report file";
    private static final String ERROR_IN_PROCESSING = "Error during the processing";
    private static final String ERROR_IN_CREATING_TEMP_FILE = "Can't create temporary file for XML report";
    private static final String ERROR_IN_SAVING_REPORT = "Can't serialize xml report";
    private List<File> pdfs;
    private ValidationProfile customProfile;
    private File policy;
    private CheckerPanel parent;
    private ConfigManager configManager;
    private File xmlReport = null;
    private File htmlReport = null;
    private BatchSummary batchSummary = null;

    ValidateWorker(CheckerPanel parent, List<File> pdfs, ConfigManager configManager, ValidationProfile customProfile, File policy) {
        if (pdfs == null) {
            throw new IllegalArgumentException("List of pdf files can not be null");
        }
        this.parent = parent;
        this.pdfs = pdfs;
        this.configManager = configManager;
        this.customProfile = customProfile;
        this.policy = policy;
    }

    @Override
    protected BatchSummary doInBackground() {
        try {
            this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
            this.xmlReport.deleteOnExit();
            this.htmlReport = null;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ERROR_IN_CREATING_TEMP_FILE, e);
            this.parent.errorInValidatingOccur("Can't create temporary file for XML report: ", e);
        }
        try (FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            VeraAppConfig veraAppConfig = this.parent.appConfigFromState();
            ProcessType processType = veraAppConfig.getProcessType();
            EnumSet<TaskType> tasks = processType.getTasks();
            ValidatorConfig validatorConfig = this.configManager.getValidatorConfig();
            ProcessorConfig resultConfig = this.customProfile == null ? ProcessorFactory.fromValues(validatorConfig, this.configManager.getFeaturesConfig(), this.configManager.getFixerConfig(), tasks, veraAppConfig.getFixesFolder()) : ProcessorFactory.fromValues(validatorConfig, this.configManager.getFeaturesConfig(), this.configManager.getFixerConfig(), tasks, this.customProfile, veraAppConfig.getFixesFolder());
            BatchProcessor processor = ProcessorFactory.fileBatchProcessor(resultConfig);
            VeraAppConfig applicationConfig = this.configManager.getApplicationConfig();
            this.batchSummary = processor.process(this.pdfs, ProcessorFactory.getHandler(FormatOption.MRR, applicationConfig.isVerbose(), mrrReport, applicationConfig.getMaxFailsDisplayed(), validatorConfig.isRecordPasses()));
            if ((processType == ProcessType.POLICY || processType == ProcessType.POLICY_FIX) && this.policy != null) {
                this.applyPolicy();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, ERROR_IN_OPEN_STREAMS, e);
            this.parent.errorInValidatingOccur("Can't open stream from PDF file or can't open stream to temporary XML report file: ", e);
        }
        catch (VeraPDFException e) {
            logger.log(Level.SEVERE, ERROR_IN_PROCESSING, e);
            this.parent.errorInValidatingOccur("Error during the processing: ", e);
        }
        if (this.batchSummary != null) {
            this.writeHtmlReport();
        }
        return this.batchSummary;
    }

    private void applyPolicy() throws IOException, VeraPDFException {
        File tempMrrFile = this.xmlReport;
        this.xmlReport = File.createTempFile("veraPDF-tempXMLReport", ".xml");
        this.xmlReport.deleteOnExit();
        File tempPolicyResult = File.createTempFile("policyResult", "veraPDF");
        tempPolicyResult.deleteOnExit();
        try (FileInputStream mrrIs = new FileInputStream(tempMrrFile);
             FileOutputStream policyResultOs = new FileOutputStream(tempPolicyResult);
             FileOutputStream mrrReport = new FileOutputStream(this.xmlReport);){
            PolicyChecker.applyPolicy(this.policy, mrrIs, policyResultOs);
            PolicyChecker.insertPolicyReport(tempPolicyResult, tempMrrFile, mrrReport);
        }
    }

    @Override
    protected void done() {
        this.parent.validationEnded(this.xmlReport, this.htmlReport);
    }

    private void writeHtmlReport() {
        try {
            this.htmlReport = File.createTempFile("veraPDF-tempHTMLReport", ".html");
            this.htmlReport.deleteOnExit();
            try (FileInputStream xmlStream = new FileInputStream(this.xmlReport);
                 FileOutputStream htmlStream = new FileOutputStream(this.htmlReport);){
                HTMLReport.writeHTMLReport(xmlStream, htmlStream, this.batchSummary, this.configManager.getApplicationConfig().getWikiPath(), true);
            }
            catch (IOException | TransformerException e) {
                JOptionPane.showMessageDialog(this.parent, "Some error in saving the HTML report: " + e.getMessage(), "Error", 0);
                logger.log(Level.SEVERE, "Exception saving the HTML report", e);
                this.htmlReport = null;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, "Some error in saving the HTML report: " + e.getMessage(), "Error", 0);
            logger.log(Level.SEVERE, "Exception saving the HTML report", e);
            this.htmlReport = null;
        }
    }
}

