/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.AuditDurationImpl;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.AbstractXmlHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.MetadataFixerReport;
import org.verapdf.processor.reports.Reports;
import org.verapdf.processor.reports.ValidationDetails;
import org.verapdf.processor.reports.ValidationReport;
import org.verapdf.report.FeaturesReport;

final class MrrHandler
extends AbstractXmlHandler {
    private static final Logger logger = Logger.getLogger(MrrHandler.class.getCanonicalName());
    private static final String STATEMENT_PREFIX = "PDF file is ";
    private static final String NOT_INSERT = "not ";
    private static final String STATEMENT_SUFFIX = "compliant with Validation Profile requirements.";
    private static final String COMPLIANT_STATEMENT = "PDF file is compliant with Validation Profile requirements.";
    private static final String NONCOMPLIANT_STATEMENT = "PDF file is not compliant with Validation Profile requirements.";
    private static final String report = "report";
    private static final String job = "job";
    private static final String jobs = "jobs";
    private static final String processingTime = "processingTime";
    private static final String buildInformation = "buildInformation";
    private final int maxFailedChecks;
    private final boolean logPassed;

    private MrrHandler(Writer dest) throws VeraPDFException {
        this(dest, 100, false);
    }

    private MrrHandler(Writer dest, int maxFailedChecks, boolean logPassed) throws VeraPDFException {
        this(dest, 2, maxFailedChecks, logPassed);
    }

    private MrrHandler(Writer dest, int indentSize, int maxFailedChecks, boolean logPassed) throws VeraPDFException {
        super(dest, indentSize);
        this.maxFailedChecks = maxFailedChecks;
        this.logPassed = logPassed;
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) throws VeraPDFException {
        try {
            MrrHandler.startDoc(this.writer);
            this.indentElement(report);
            this.addReleaseDetails();
            this.indentElement(jobs);
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    private void addReleaseDetails() throws XMLStreamException, VeraPDFException {
        this.indentElement(buildInformation);
        for (ReleaseDetails details : ReleaseDetails.getDetails()) {
            try {
                XmlSerialiser.toXml(details, this.writer, true, true);
                this.writer.flush();
            }
            catch (JAXBException excep) {
                logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "releaseDetails"), excep);
                throw MrrHandler.wrapMarshallException(excep, "releaseDetails");
            }
        }
        this.outdentElement();
    }

    @Override
    void resultStart(ProcessorResult result) throws VeraPDFException {
        try {
            this.indentElement(job);
            XmlSerialiser.toXml(result.getProcessedItem(), this.writer, true, true);
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "itemDetails"), excep);
            throw MrrHandler.wrapMarshallException(excep, "itemDetails");
        }
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(taskResult, this.writer, true, true);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "taskResult"), excep);
            throw MrrHandler.wrapMarshallException(excep, "taskResult");
        }
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(taskResult, this.writer, true, true);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "taskResult"), excep);
            throw MrrHandler.wrapMarshallException(excep, "taskResult");
        }
    }

    @Override
    void validationSuccess(TaskResult taskResult, ValidationResult result) throws VeraPDFException {
        ValidationDetails details = Reports.fromValues(result, this.logPassed, this.maxFailedChecks);
        ValidationReport valRep = Reports.createValidationReport(details, result.getProfileDetails().getName(), MrrHandler.getStatement(result.isCompliant()), result.isCompliant());
        try {
            XmlSerialiser.toXml(valRep, this.writer, true, true);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "validationReport"), excep);
            throw MrrHandler.wrapMarshallException(excep, "validationReport");
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(taskResult, this.writer, true, true);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "taskResult"), excep);
            throw MrrHandler.wrapMarshallException(excep, "taskResult");
        }
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featuresReport) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(featuresReport, this.writer, true, true);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "featuresReport"), excep);
            throw MrrHandler.wrapMarshallException(excep, "featuresReport");
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    void featureFailure(TaskResult taskResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(taskResult, this.writer, true, true);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "taskResult"), excep);
            throw MrrHandler.wrapMarshallException(excep, "taskResult");
        }
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) throws VeraPDFException {
        MetadataFixerReport mfRep = Reports.fromValues(fixerResult);
        try {
            XmlSerialiser.toXml(mfRep, this.writer, true, true);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "fixerReport"), excep);
            throw MrrHandler.wrapMarshallException(excep, "fixerReport");
        }
    }

    @Override
    void fixerFailure(TaskResult taskResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(taskResult, this.writer, true, true);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "taskResult"), excep);
            throw MrrHandler.wrapMarshallException(excep, "taskResult");
        }
    }

    @Override
    void resultEnd(ProcessorResult result) throws VeraPDFException {
        try {
            this.indentElement(processingTime);
            long resTime = AuditDurationImpl.sumDuration(MrrHandler.getDurations(result));
            this.writer.writeCharacters(AuditDurationImpl.getStringDuration(resTime));
            this.outdentElement();
            this.outdentElement();
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        try {
            this.outdentElement();
            XmlSerialiser.toXml(summary, this.writer, true, true);
            MrrHandler.newLine(this.writer);
            this.outdentElement();
            this.writer.flush();
            MrrHandler.endDoc(this.writer);
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "batchSummary"), excep);
            throw MrrHandler.wrapMarshallException(excep, "batchSummary");
        }
        try {
            this.writer.close();
        }
        catch (XMLStreamException excep) {
            logger.log(Level.INFO, String.format("XmlStreamException caught when %s output writer.", "closing"), excep);
        }
    }

    private static Collection<AuditDuration> getDurations(ProcessorResult result) {
        EnumMap<TaskType, TaskResult> results = result.getResults();
        if (results != null) {
            ArrayList<AuditDuration> res = new ArrayList<AuditDuration>();
            for (TaskType type : results.keySet()) {
                if (results.get((Object)type).getDuration() == null) continue;
                res.add(results.get((Object)type).getDuration());
            }
            return res;
        }
        return Collections.emptyList();
    }

    protected static VeraPDFException wrapStreamException(JAXBException excep, String typePart) {
        return new VeraPDFException(String.format("Unmarshalling exception when streaming %s.", typePart), excep);
    }

    static BatchProcessingHandler newInstance(Writer dest, boolean logPassed, int maxFailedChecks) throws VeraPDFException {
        return new MrrHandler(dest, maxFailedChecks, logPassed);
    }

    static BatchProcessingHandler newInstance(Writer dest, int indent, boolean logPassed, int maxFailedChecks) throws VeraPDFException {
        return new MrrHandler(dest, indent, maxFailedChecks, logPassed);
    }

    private static String getStatement(boolean status) {
        return status ? COMPLIANT_STATEMENT : NONCOMPLIANT_STATEMENT;
    }
}

