/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDStructElem;

public class TaggedPDFHelper {
    private static final Logger LOGGER = Logger.getLogger(TaggedPDFHelper.class.getCanonicalName());
    private static final int MAX_NUMBER_OF_ELEMENTS = 1;

    private TaggedPDFHelper() {
    }

    public static List<PDStructElem> getStructTreeRootChildren(COSObject parent) {
        return TaggedPDFHelper.getChildren(parent, false);
    }

    public static List<PDStructElem> getStructElemChildren(COSObject parent) {
        return TaggedPDFHelper.getChildren(parent, true);
    }

    private static List<PDStructElem> getChildren(COSObject parent, boolean checkType) {
        if (parent == null || parent.getType() != COSObjType.COS_DICT) {
            LOGGER.log(Level.FINE, "Parent element for struct elements is null or not a COSDictionary");
            return Collections.emptyList();
        }
        COSObject children = parent.getKey(ASAtom.K);
        if (children != null) {
            if (children.getType() == COSObjType.COS_DICT && TaggedPDFHelper.isStructElem(children, checkType)) {
                ArrayList<PDStructElem> list = new ArrayList<PDStructElem>(1);
                list.add(new PDStructElem(children));
                return Collections.unmodifiableList(list);
            }
            if (children.getType() == COSObjType.COS_ARRAY) {
                return TaggedPDFHelper.getChildrenFromArray(children, checkType);
            }
        }
        return Collections.emptyList();
    }

    private static List<PDStructElem> getChildrenFromArray(COSObject children, boolean checkType) {
        if (children.size() > 0) {
            ArrayList<PDStructElem> list = new ArrayList<PDStructElem>();
            for (int i = 0; i < children.size(); ++i) {
                COSObject elem = children.at(i);
                if (elem.getType() != COSObjType.COS_DICT || !TaggedPDFHelper.isStructElem(elem, checkType)) continue;
                list.add(new PDStructElem(elem));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static boolean isStructElem(COSObject dictionary, boolean checkType) {
        if (dictionary == null || dictionary.getType() != COSObjType.COS_DICT) {
            return false;
        }
        ASAtom type = dictionary.getNameKey(ASAtom.TYPE);
        return !checkType || type == null || type.equals(ASAtom.STRUCT_ELEM);
    }
}

