/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.ColorSpaceFeaturesObjectAdapter;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class ColorSpaceFeaturesObject
extends FeaturesObject {
    private static final String CALGRAY = "CalGray";
    private static final String CALRGB = "CalRGB";
    private static final String LAB = "Lab";
    private static final String ICCBASED = "ICCBased";
    private static final String INDEXED = "Indexed";
    private static final String SEPARATION = "Separation";
    private static final String DEVICEN = "DeviceN";
    private static final String COLOR_SPACE = "colorSpace";
    private static final String FAMILY = "family";

    public ColorSpaceFeaturesObject(ColorSpaceFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.COLORSPACE;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        ColorSpaceFeaturesObjectAdapter csAdapter = (ColorSpaceFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(COLOR_SPACE);
        String id = csAdapter.getId();
        if (id != null) {
            root.setAttribute("id", id);
        }
        String colorSpaceType = csAdapter.getFamily();
        root.setAttribute(FAMILY, colorSpaceType);
        if (CALGRAY.equals(colorSpaceType) || CALRGB.equals(colorSpaceType) || LAB.equals(colorSpaceType)) {
            this.parseCIEDictionaryBased(root, csAdapter);
        } else if (ICCBASED.equals(colorSpaceType)) {
            String colorSpaceChild = csAdapter.getColorSpaceChild();
            if (colorSpaceChild != null) {
                FeatureTreeNode alt = root.addChild("alternate");
                alt.setAttribute("id", colorSpaceChild);
            }
            root.addChild("components").setValue(String.valueOf(csAdapter.getNumberOfComponents()));
            String iccProfileChild = csAdapter.getICCProfileChild();
            if (iccProfileChild != null) {
                FeatureTreeNode prof = root.addChild("iccProfile");
                prof.setAttribute("id", iccProfileChild);
            }
        } else if (INDEXED.equals(colorSpaceType)) {
            Long hival;
            String colorSpaceChild = csAdapter.getColorSpaceChild();
            if (colorSpaceChild != null) {
                FeatureTreeNode alt = root.addChild("base");
                alt.setAttribute("id", colorSpaceChild);
            }
            if ((hival = csAdapter.getHival()) != null) {
                CreateNodeHelper.addNotEmptyNode("hival", String.valueOf(hival), root);
            }
            CreateNodeHelper.addNotEmptyNode("lookup", csAdapter.getHexEncodedLookup(), root);
        } else if (SEPARATION.equals(colorSpaceType)) {
            String colorSpaceChild = csAdapter.getColorSpaceChild();
            if (colorSpaceChild != null) {
                FeatureTreeNode alt = root.addChild("alternate");
                alt.setAttribute("id", colorSpaceChild);
            }
            CreateNodeHelper.addNotEmptyNode("colorantName", csAdapter.getColorantName(), root);
        } else if (DEVICEN.equals(colorSpaceType)) {
            List<String> devNColorantNames;
            String colorSpaceChild = csAdapter.getColorSpaceChild();
            if (colorSpaceChild != null) {
                FeatureTreeNode alt = root.addChild("alternate");
                alt.setAttribute("id", colorSpaceChild);
            }
            if ((devNColorantNames = csAdapter.getColorantNames()) != null) {
                FeatureTreeNode colorantNames = root.addChild("colorantNames");
                for (String name : devNColorantNames) {
                    CreateNodeHelper.addNotEmptyNode("colorantName", name, colorantNames);
                }
            }
        }
        return root;
    }

    private void parseCIEDictionaryBased(FeatureTreeNode root, ColorSpaceFeaturesObjectAdapter adapter) throws FeatureParsingException {
        this.parseTristimulus(adapter.getWhitePoint(), root.addChild("whitePoint"));
        this.parseTristimulus(adapter.getBlackPoint(), root.addChild("blackPoint"));
        String cieType = adapter.getFamily();
        if (CALGRAY.equals(cieType)) {
            Double gamma = adapter.getCalGrayGamma();
            if (gamma != null) {
                CreateNodeHelper.addNotEmptyNode("gamma", String.format("%.3f", gamma), root);
            }
        } else if (CALRGB.equals(cieType)) {
            FeatureTreeNode gamma = root.addChild("gamma");
            double[] gammaValue = adapter.getCalRGBGamma();
            if (gammaValue == null) {
                this.registerNewError("Gamma value is not present");
            } else if (gammaValue.length < 3) {
                this.registerNewError("Gamma value contains less than three elements");
            } else {
                gamma.setAttribute("red", String.format("%.3f", gammaValue[0]));
                gamma.setAttribute("green", String.format("%.3f", gammaValue[1]));
                gamma.setAttribute("blue", String.format("%.3f", gammaValue[2]));
            }
            this.parseFloatArray(adapter.getMatrix(), root.addChild("matrix"));
        } else if (LAB.equals(cieType)) {
            FeatureTreeNode range = root.addChild("range");
            double[] rangeValue = adapter.getLabRange();
            if (rangeValue.length < 4) {
                this.registerNewError("Gamma value contains less than three elements");
            } else {
                range.setAttribute("aMin", String.format("%.3f", rangeValue[0]));
                range.setAttribute("aMax", String.format("%.3f", rangeValue[1]));
                range.setAttribute("bMin", String.format("%.3f", rangeValue[2]));
                range.setAttribute("bMax", String.format("%.3f", rangeValue[3]));
            }
        }
    }

    private void parseFloatArray(double[] array, FeatureTreeNode parent) throws FeatureParsingException {
        for (int i = 0; i < array.length; ++i) {
            FeatureTreeNode element = parent.addChild("element");
            element.setAttribute("number", String.valueOf(i));
            element.setAttribute("value", String.format("%.3f", array[i]));
        }
    }

    private void parseTristimulus(double[] tris, FeatureTreeNode curNode) {
        if (tris == null) {
            return;
        }
        if (tris.length < 3) {
            this.registerNewError("Tristimulus value contains less than three elements");
        } else {
            curNode.setAttribute("x", String.format("%.3f", tris[0]));
            curNode.setAttribute("y", String.format("%.3f", tris[1]));
            curNode.setAttribute("z", String.format("%.3f", tris[2]));
        }
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Family", ColorSpaceFeaturesObject.generateAttributeXPath(COLOR_SPACE, FAMILY), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Error IDs", ColorSpaceFeaturesObject.generateAttributeXPath(COLOR_SPACE, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

