/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSString;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.model.external.PKCSDataObject;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;

public class GFPKCSDataObject
extends GFExternal
implements PKCSDataObject {
    private static final Logger LOGGER = Logger.getLogger(GFPKCSDataObject.class.getCanonicalName());
    public static final String PKCS_DATA_OBJECT_TYPE = "PKCSDataObject";
    private PKCS7 pkcs7;

    public GFPKCSDataObject(COSString pkcsData) {
        super(PKCS_DATA_OBJECT_TYPE);
        try {
            if (!pkcsData.isHexadecimal()) {
                this.pkcs7 = new PKCS7(pkcsData.get());
            } else {
                byte[] decodedData = pkcsData.get();
                this.pkcs7 = new PKCS7(decodedData);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Passed PKCS7 object can't be read", e);
            this.pkcs7 = GFPKCSDataObject.getEmptyPKCS7();
        }
    }

    @Override
    public Long getSignerInfoCount() {
        return new Long(this.pkcs7.getSignerInfos().length);
    }

    @Override
    public Boolean getsigningCertificatePresent() {
        X509Certificate[] certificates = this.pkcs7.getCertificates();
        if (certificates.length == 0) {
            return Boolean.FALSE;
        }
        for (X509Certificate cert : certificates) {
            if (cert != null) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static PKCS7 getEmptyPKCS7() {
        return new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), new X509Certificate[0], new SignerInfo[0]);
    }
}

