/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.gf.model.impl.external.GFFontProgram;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;

public class GFTrueTypeFontProgram
extends GFFontProgram
implements org.verapdf.model.external.TrueTypeFontProgram {
    private static final Logger LOGGER = Logger.getLogger(GFTrueTypeFontProgram.class.getCanonicalName());
    private TrueTypeFontProgram trueTypeFont;
    public static final String TRUE_TYPE_PROGRAM_TYPE = "TrueTypeFontProgram";

    public GFTrueTypeFontProgram(FontProgram trueTypeFont) {
        super(TRUE_TYPE_PROGRAM_TYPE);
        try {
            if (trueTypeFont instanceof OpenTypeFontProgram) {
                this.trueTypeFont = (TrueTypeFontProgram)((OpenTypeFontProgram)trueTypeFont).getFont();
            }
            this.trueTypeFont = (TrueTypeFontProgram)trueTypeFont;
            this.trueTypeFont.parseFont();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error in parsing embedded True Type font file", e);
        }
    }

    @Override
    public Boolean getisSymbolic() {
        return this.trueTypeFont.isSymbolic();
    }

    @Override
    public Long getnrCmaps() {
        return new Long(this.trueTypeFont.getNrOfEncodingCMaps());
    }

    @Override
    public Boolean getcmap30Present() {
        return this.trueTypeFont.isCmapPresent(3, 0);
    }
}

