/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.gf.model.impl.pd.util.TaggedPDFRoleMapHelper;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.pd.PDDocument;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class StaticContainers {
    private static PDDocument document;
    private static PDFAFlavour flavour;
    public static TaggedPDFRoleMapHelper roleMapHelper;
    public static Map<String, List<GFPDSeparation>> separations;
    public static List<String> inconsistentSeparations;
    public static Map<String, PDColorSpace> cachedColorSpaces;
    public static Set<COSKey> fileSpecificationKeys;

    public static void clearAllContainers() {
        if (document != null) {
            document = null;
        }
        flavour = null;
        roleMapHelper = null;
        separations.clear();
        inconsistentSeparations.clear();
        cachedColorSpaces.clear();
        fileSpecificationKeys.clear();
    }

    public static PDDocument getDocument() {
        return document;
    }

    public static void setDocument(PDDocument document) {
        StaticContainers.document = document;
    }

    public static PDFAFlavour getFlavour() {
        return flavour;
    }

    public static void setFlavour(PDFAFlavour flavour) {
        StaticContainers.flavour = flavour;
        if (roleMapHelper != null) {
            roleMapHelper.setFlavour(flavour);
        }
    }

    public static TaggedPDFRoleMapHelper getRoleMapHelper() {
        return roleMapHelper;
    }

    public static void setRoleMapHelper(Map<ASAtom, ASAtom> roleMap) {
        roleMapHelper = new TaggedPDFRoleMapHelper(roleMap, flavour);
    }

    static {
        separations = new HashMap<String, List<GFPDSeparation>>();
        inconsistentSeparations = new ArrayList<String>();
        cachedColorSpaces = new HashMap<String, PDColorSpace>();
        fileSpecificationKeys = new HashSet<COSKey>();
    }
}

