/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.action.PDNavigationNode;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDTransition;
import org.apache.pdfbox.util.Matrix;

public class PDPage
implements COSObjectable,
PDContentStream {
    private static final Log LOG = LogFactory.getLog(PDPage.class);
    private final COSDictionary page;
    private PDResources pageResources;
    private PDRectangle mediaBox;

    public PDPage() {
        this(PDRectangle.LETTER);
    }

    public PDPage(PDRectangle mediaBox) {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
        this.page.setItem(COSName.MEDIA_BOX, (COSObjectable)mediaBox);
    }

    public PDPage(COSDictionary pageDictionary) {
        this.page = pageDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.page;
    }

    @Override
    public COSStream getContentStream() {
        COSBase base = this.page.getDictionaryObject(COSName.CONTENTS);
        if (base instanceof COSStream) {
            return (COSStream)base;
        }
        if (base instanceof COSArray && ((COSArray)base).size() > 0) {
            return new COSStreamArray((COSArray)base);
        }
        return null;
    }

    @Override
    public PDResources getResources() {
        COSDictionary resources;
        if (this.pageResources == null && (resources = (COSDictionary)PDPageTree.getInheritableAttribute(this.page, COSName.RESOURCES)) != null) {
            this.pageResources = new PDResources(resources);
        }
        return this.pageResources;
    }

    public void setResources(PDResources resources) {
        this.pageResources = resources;
        if (resources != null) {
            this.page.setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.page.removeItem(COSName.RESOURCES);
        }
    }

    public PDResources getPageResources() {
        COSDictionary value;
        if (this.pageResources == null && (value = (COSDictionary)this.page.getDictionaryObject(COSName.RESOURCES)) != null) {
            return new PDResources(value);
        }
        return null;
    }

    public PDResources getInheritedResources() {
        COSDictionary resources;
        COSDictionary parent = (COSDictionary)this.page.getDictionaryObject(COSName.PARENT, COSName.P);
        if (parent != null && (resources = (COSDictionary)PDPageTree.getInheritableAttribute(parent, COSName.RESOURCES)) != null) {
            return new PDResources(resources);
        }
        return null;
    }

    public int getStructParents() {
        return this.page.getInt(COSName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParents) {
        this.page.setInt(COSName.STRUCT_PARENTS, structParents);
    }

    @Override
    public PDRectangle getBBox() {
        return this.getCropBox();
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix();
    }

    public PDRectangle getMediaBox() {
        COSArray array;
        if (this.mediaBox == null && (array = (COSArray)PDPageTree.getInheritableAttribute(this.page, COSName.MEDIA_BOX)) != null) {
            this.mediaBox = new PDRectangle(array);
        }
        if (this.mediaBox == null) {
            LOG.debug("Can't find MediaBox, will use U.S. Letter");
            this.mediaBox = PDRectangle.LETTER;
        }
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
        if (mediaBox == null) {
            this.page.removeItem(COSName.MEDIA_BOX);
        } else {
            this.page.setItem(COSName.MEDIA_BOX, (COSObjectable)mediaBox);
        }
    }

    public PDRectangle getCropBox() {
        COSArray array = (COSArray)PDPageTree.getInheritableAttribute(this.page, COSName.CROP_BOX);
        if (array != null) {
            return this.clipToMediaBox(new PDRectangle(array));
        }
        return this.getMediaBox();
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.CROP_BOX);
        } else {
            this.page.setItem(COSName.CROP_BOX, (COSBase)cropBox.getCOSArray());
        }
    }

    public PDRectangle getBleedBox() {
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.BLEED_BOX);
        PDRectangle retval = array != null ? this.clipToMediaBox(new PDRectangle(array)) : this.getCropBox();
        return retval;
    }

    public void setBleedBox(PDRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(COSName.BLEED_BOX);
        } else {
            this.page.setItem(COSName.BLEED_BOX, (COSObjectable)bleedBox);
        }
    }

    public PDRectangle getTrimBox() {
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.TRIM_BOX);
        PDRectangle retval = array != null ? this.clipToMediaBox(new PDRectangle(array)) : this.getCropBox();
        return retval;
    }

    public void setTrimBox(PDRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(COSName.TRIM_BOX);
        } else {
            this.page.setItem(COSName.TRIM_BOX, (COSObjectable)trimBox);
        }
    }

    public PDRectangle getArtBox() {
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.ART_BOX);
        PDRectangle retval = array != null ? this.clipToMediaBox(new PDRectangle(array)) : this.getCropBox();
        return retval;
    }

    public void setArtBox(PDRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(COSName.ART_BOX);
        } else {
            this.page.setItem(COSName.ART_BOX, (COSObjectable)artBox);
        }
    }

    private PDRectangle clipToMediaBox(PDRectangle box) {
        PDRectangle mediaBox = this.getMediaBox();
        PDRectangle result = new PDRectangle();
        result.setLowerLeftX(Math.max(mediaBox.getLowerLeftX(), box.getLowerLeftX()));
        result.setLowerLeftY(Math.max(mediaBox.getLowerLeftY(), box.getLowerLeftY()));
        result.setUpperRightX(Math.min(mediaBox.getUpperRightX(), box.getUpperRightX()));
        result.setUpperRightY(Math.min(mediaBox.getUpperRightY(), box.getUpperRightY()));
        return result;
    }

    public int getRotation() {
        int rotationAngle;
        COSBase obj = PDPageTree.getInheritableAttribute(this.page, COSName.ROTATE);
        if (obj instanceof COSNumber && (rotationAngle = ((COSNumber)obj).intValue()) % 90 == 0) {
            return (rotationAngle % 360 + 360) % 360;
        }
        return 0;
    }

    public boolean hasRotation() {
        return PDPageTree.getInheritableAttribute(this.page, COSName.ROTATE) != null;
    }

    public void setRotation(int rotation) {
        this.page.setInt(COSName.ROTATE, rotation);
    }

    public PDStream getStream() throws IOException {
        return PDStream.createFromCOS(this.page.getDictionaryObject(COSName.CONTENTS));
    }

    public void setContents(PDStream contents) {
        this.page.setItem(COSName.CONTENTS, (COSObjectable)contents);
    }

    public List<PDThreadBead> getThreadBeads() {
        COSArray beads = (COSArray)this.page.getDictionaryObject(COSName.B);
        if (beads == null) {
            beads = new COSArray();
        }
        ArrayList<PDThreadBead> pdObjects = new ArrayList<PDThreadBead>();
        for (int i = 0; i < beads.size(); ++i) {
            COSDictionary beadDic = (COSDictionary)beads.getObject(i);
            PDThreadBead bead = null;
            if (beadDic != null) {
                bead = new PDThreadBead(beadDic);
            }
            pdObjects.add(bead);
        }
        return new COSArrayList<PDThreadBead>(pdObjects, beads);
    }

    public void setThreadBeads(List<PDThreadBead> beads) {
        this.page.setItem(COSName.B, (COSBase)COSArrayList.converterToCOSArray(beads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.page.getDictionaryObject(COSName.METADATA);
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.page.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public PDPageAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.page.getDictionaryObject(COSName.AA);
        if (addAct == null) {
            addAct = new COSDictionary();
            this.page.setItem(COSName.AA, (COSBase)addAct);
        }
        return new PDPageAdditionalActions(addAct);
    }

    public PDNavigationNode getPresSteps() {
        COSBase presSteps = this.page.getDictionaryObject(COSName.PRES_STEPS);
        if (presSteps != null && presSteps instanceof COSDictionary) {
            return new PDNavigationNode((COSDictionary)presSteps);
        }
        return null;
    }

    public void setActions(PDPageAdditionalActions actions) {
        this.page.setItem(COSName.AA, (COSObjectable)actions);
    }

    public PDTransition getTransition() {
        COSDictionary transitionDictionary = (COSDictionary)this.page.getDictionaryObject(COSName.TRANS);
        return transitionDictionary == null ? null : new PDTransition(transitionDictionary);
    }

    public void setTransition(PDTransition transition) {
        this.page.setItem(COSName.TRANS, (COSObjectable)transition);
    }

    public void setTransition(PDTransition transition, float duration) {
        this.page.setItem(COSName.TRANS, (COSObjectable)transition);
        this.page.setItem(COSName.DUR, (COSBase)new COSFloat(duration));
    }

    public List<PDAnnotation> getAnnotations() throws IOException {
        COSArrayList<PDAnnotation> retval;
        COSArray annots = (COSArray)this.page.getDictionaryObject(COSName.ANNOTS);
        if (annots == null) {
            annots = new COSArray();
            this.page.setItem(COSName.ANNOTS, (COSBase)annots);
            retval = new COSArrayList(new ArrayList(), annots);
        } else {
            ArrayList<PDAnnotation> actuals = new ArrayList<PDAnnotation>();
            for (int i = 0; i < annots.size(); ++i) {
                COSBase item = annots.getObject(i);
                if (item == null) continue;
                actuals.add(PDAnnotation.createAnnotation(item));
            }
            retval = new COSArrayList<PDAnnotation>(actuals, annots);
        }
        return retval;
    }

    public void setAnnotations(List<PDAnnotation> annotations) {
        this.page.setItem(COSName.ANNOTS, (COSBase)COSArrayList.converterToCOSArray(annotations));
    }

    public boolean equals(Object other) {
        return other instanceof PDPage && ((PDPage)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.page.hashCode();
    }
}

