/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.verapdf.features.objects.FontFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBFontFeaturesObjectAdapter
implements FontFeaturesObjectAdapter {
    private static final Logger LOGGER = Logger.getLogger(PBFontFeaturesObjectAdapter.class);
    private PDFontLike fontLike;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private String type;
    private String baseFont;
    private Long firstChar;
    private Long lastChar;
    private String encoding;
    private double[] bbox;
    private double[] matrix;
    private boolean isCIDSystemInfoPresent;
    private Double defaultWidth;
    private String cidSysInfoRegistry;
    private String cidSysInfoOrdering;
    private Long cidSysInfoSupplement;
    private PDFontDescriptorAdapter fontDescriptor;

    public PBFontFeaturesObjectAdapter(PDFontLike fontLike, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.fontLike = fontLike;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.init();
    }

    private void init() {
        if (this.fontLike != null) {
            if (this.fontLike instanceof PDFont) {
                PDFont font = (PDFont)this.fontLike;
                this.type = font.getSubType();
                if (!(font instanceof PDType3Font)) {
                    this.baseFont = font.getName();
                }
                if (font instanceof PDSimpleFont) {
                    COSBase name;
                    COSBase enc;
                    int lc;
                    PDSimpleFont sFont = (PDSimpleFont)font;
                    int fc = sFont.getCOSObject().getInt(COSName.FIRST_CHAR);
                    if (fc != -1) {
                        this.firstChar = fc;
                    }
                    if ((lc = sFont.getCOSObject().getInt(COSName.LAST_CHAR)) != -1) {
                        this.lastChar = lc;
                    }
                    if ((enc = sFont.getCOSObject().getDictionaryObject(COSName.ENCODING)) instanceof COSName) {
                        this.encoding = ((COSName)enc).getName();
                    } else if (enc instanceof COSDictionary && (name = ((COSDictionary)enc).getDictionaryObject(COSName.BASE_ENCODING)) instanceof COSName) {
                        this.encoding = ((COSName)name).getName();
                    }
                    if (sFont instanceof PDType3Font) {
                        PDType3Font type3 = (PDType3Font)sFont;
                        this.bbox = PBAdapterHelper.parseRectangle(type3.getFontBBox());
                        this.matrix = PBAdapterHelper.parseFloatMatrix(type3.getFontMatrix().getValues());
                    }
                }
            } else if (this.fontLike instanceof PDCIDFont) {
                PDCIDSystemInfo cidSystemInfo;
                PDCIDFont cid = (PDCIDFont)this.fontLike;
                this.type = cid.getCOSObject().getNameAsString(COSName.SUBTYPE);
                this.baseFont = cid.getBaseFont();
                COSBase dw = cid.getCOSObject().getDictionaryObject(COSName.DW);
                if (dw instanceof COSInteger) {
                    this.defaultWidth = ((COSNumber)dw).intValue();
                }
                boolean bl = this.isCIDSystemInfoPresent = (cidSystemInfo = cid.getCIDSystemInfo()) != null;
                if (this.isCIDSystemInfoPresent) {
                    this.cidSysInfoRegistry = cidSystemInfo.getRegistry();
                    this.cidSysInfoOrdering = cidSystemInfo.getOrdering();
                    this.cidSysInfoSupplement = cidSystemInfo.getSupplement();
                }
            }
            PDFontDescriptor fontDescriptor = this.fontLike.getFontDescriptor();
            if (fontDescriptor != null) {
                this.fontDescriptor = new PDFontDescriptorAdapter(fontDescriptor);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getExtGStateChild() {
        return this.extGStateChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.extGStateChild);
    }

    @Override
    public Set<String> getColorSpaceChild() {
        return this.colorSpaceChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.colorSpaceChild);
    }

    @Override
    public Set<String> getPatternChild() {
        return this.patternChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.patternChild);
    }

    @Override
    public Set<String> getShadingChild() {
        return this.shadingChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.shadingChild);
    }

    @Override
    public Set<String> getXObjectChild() {
        return this.xobjectChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.xobjectChild);
    }

    @Override
    public Set<String> getFontChild() {
        return this.fontChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.fontChild);
    }

    @Override
    public Set<String> getPropertiesChild() {
        return this.propertiesChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.propertiesChild);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getBaseFont() {
        return this.baseFont;
    }

    @Override
    public Long getFirstChar() {
        return this.firstChar;
    }

    @Override
    public Long getLastChar() {
        return this.lastChar;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public double[] getBoundingBox() {
        return this.bbox;
    }

    @Override
    public double[] getMatrix() {
        return this.matrix;
    }

    @Override
    public boolean isCIDSystemInfoPresent() {
        return this.isCIDSystemInfoPresent;
    }

    @Override
    public Double getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public String getCIDSysInfoRegistry() {
        return this.cidSysInfoRegistry;
    }

    @Override
    public String getCIDSysInfoOrdering() {
        return this.cidSysInfoOrdering;
    }

    @Override
    public Long getCIDSysInfoSupplement() {
        return this.cidSysInfoSupplement;
    }

    @Override
    public FontFeaturesObjectAdapter.FontDescriptorAdapter getFontDescriptor() {
        return this.fontDescriptor;
    }

    @Override
    public boolean isPDFObjectPresent() {
        return this.fontLike != null;
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private static class PDFontDescriptorAdapter
    implements FontFeaturesObjectAdapter.FontDescriptorAdapter {
        private PDFontDescriptor descriptor;
        private PDStream file;

        PDFontDescriptorAdapter(PDFontDescriptor descriptor) {
            this.descriptor = descriptor;
            this.file = descriptor.getFontFile();
            if (this.file == null) {
                this.file = descriptor.getFontFile2();
            }
            if (this.file == null) {
                this.file = descriptor.getFontFile3();
            }
        }

        @Override
        public String getFontName() {
            return this.descriptor.getFontName();
        }

        @Override
        public String getFontFamily() {
            return this.descriptor.getFontFamily();
        }

        @Override
        public String getFontStretch() {
            return this.descriptor.getFontStretch();
        }

        @Override
        public Double getFontWeight() {
            if (this.descriptor.getCOSObject().containsKey(COSName.FONT_WEIGHT)) {
                return this.descriptor.getFontWeight();
            }
            return null;
        }

        @Override
        public boolean isFixedPitch() {
            return this.descriptor.isFixedPitch();
        }

        @Override
        public boolean isSerif() {
            return this.descriptor.isSerif();
        }

        @Override
        public boolean isSymbolic() {
            return this.descriptor.isSymbolic();
        }

        @Override
        public boolean isScript() {
            return this.descriptor.isScript();
        }

        @Override
        public boolean isNonSymbolic() {
            return this.descriptor.isNonSymbolic();
        }

        @Override
        public boolean isItalic() {
            return this.descriptor.isItalic();
        }

        @Override
        public boolean isAllcap() {
            return this.descriptor.isAllCap();
        }

        @Override
        public boolean isSmallCap() {
            return this.descriptor.isSmallCap();
        }

        @Override
        public boolean isForceBold() {
            return this.descriptor.isForceBold();
        }

        @Override
        public double[] getFontBoundingBox() {
            return PBAdapterHelper.parseRectangle(this.descriptor.getFontBoundingBox());
        }

        @Override
        public Double getItalicAngle() {
            return this.descriptor.getItalicAngle();
        }

        @Override
        public Double getAscent() {
            return this.descriptor.getAscent();
        }

        @Override
        public Double getDescent() {
            return this.descriptor.getDescent();
        }

        @Override
        public Double getLeading() {
            return this.descriptor.getLeading();
        }

        @Override
        public Double getCapHeight() {
            return this.descriptor.getCapHeight();
        }

        @Override
        public Double getXHeight() {
            return this.descriptor.getXHeight();
        }

        @Override
        public Double getStemV() {
            if (this.descriptor.getCOSObject().containsKey(COSName.STEM_V)) {
                return this.descriptor.getStemV();
            }
            return null;
        }

        @Override
        public Double getStemH() {
            return this.descriptor.getStemH();
        }

        @Override
        public Double getAverageWidth() {
            return this.descriptor.getAverageWidth();
        }

        @Override
        public Double getMaxWidth() {
            return this.descriptor.getMaxWidth();
        }

        @Override
        public Double getMissingWidth() {
            return this.descriptor.getMissingWidth();
        }

        @Override
        public String getCharSet() {
            return this.descriptor.getCharSet();
        }

        @Override
        public boolean isEmbedded() {
            return this.file != null;
        }

        @Override
        public Long getFlags() {
            COSBase fl = this.descriptor.getCOSObject().getDictionaryObject(COSName.FLAGS);
            if (fl instanceof COSInteger) {
                return ((COSInteger)fl).intValue();
            }
            return null;
        }

        @Override
        public InputStream getMetadataStream() {
            if (this.file != null) {
                return PBAdapterHelper.getMetadataStream(this.file.getMetadata());
            }
            return null;
        }

        @Override
        public InputStream getData() {
            COSStream stream;
            if (this.file != null && (stream = this.file.getStream()) != null) {
                try {
                    return stream.getUnfilteredStream();
                }
                catch (IOException e) {
                    LOGGER.debug("Error while obtaining unfiltered font stream", e);
                }
            }
            return null;
        }
    }
}

