/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSDirect;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.filters.COSFilterASCIIHexEncode;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSString
extends COSDirect {
    private static final Logger LOGGER = Logger.getLogger(COSString.class.getCanonicalName());
    private byte[] value;
    private boolean isHex;
    private boolean containsOnlyHex = true;
    private long hexCount = 0L;

    public COSString() {
        this.value = new byte[0];
        this.isHex = false;
    }

    public COSString(byte[] value) {
        this(value, false);
    }

    public COSString(byte[] value, boolean isHex) {
        this.value = value;
        this.isHex = isHex;
    }

    public COSString(byte[] value, boolean isHex, long hexCount, boolean containsOnlyHex) {
        this(value, isHex);
        this.hexCount = hexCount;
        this.containsOnlyHex = containsOnlyHex;
    }

    public static COSObject construct(byte[] initValue) {
        return COSString.construct(initValue, false);
    }

    public static COSObject construct(byte[] initValue, boolean isHex) {
        return new COSObject(new COSString(initValue, isHex));
    }

    public static COSObject construct(byte[] initValue, boolean isHex, long hexCount, boolean containsOnlyHex) {
        return new COSObject(new COSString(initValue, isHex, hexCount, containsOnlyHex));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromString(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromString(this);
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_STRING;
    }

    @Override
    public Long getInteger() {
        return this.value.length;
    }

    @Override
    public Double getReal() {
        return this.value.length;
    }

    @Override
    public String getString() {
        if (this.value.length > 2 && (this.value[0] & 0xFF) == 254 && (this.value[1] & 0xFF) == 255) {
            return new String(this.value, 2, this.value.length - 2, Charset.forName("UTF-16BE"));
        }
        return new String(this.value);
    }

    @Override
    public boolean setString(String value) {
        this.value = new byte[value.length()];
        boolean utf16 = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c > '\u00ff') {
                utf16 = true;
                break;
            }
            this.value[i] = (byte)(c & 0xFF);
        }
        if (utf16) {
            try {
                byte[] utfValue = value.getBytes("UTF-16BE");
                this.value = new byte[utfValue.length + 2];
                this.value[0] = -2;
                this.value[1] = -1;
                for (int i = 0; i < utfValue.length; ++i) {
                    this.value[i + 2] = utfValue[i];
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.FINE, "Can't find encoding UTF-16BE", e);
                return false;
            }
        }
        return true;
    }

    public void setHex(boolean hex) {
        this.isHex = hex;
    }

    public boolean setString(byte[] value, boolean isHex) {
        this.value = value;
        this.isHex = isHex;
        return true;
    }

    public byte[] get() {
        return this.value;
    }

    public void set(byte[] value) {
        this.value = value;
    }

    public boolean isLiteral() {
        return !this.isHex;
    }

    public boolean isHexadecimal() {
        return this.isHex;
    }

    public String getHexString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.value.length; ++i) {
            int c = this.value[i] & 0xFF;
            result.append(COSFilterASCIIHexEncode.asciiHexBig[c]);
            result.append(COSFilterASCIIHexEncode.asciiHexLittle[c]);
        }
        return result.toString();
    }

    public String toString() {
        return this.isHex ? this.toHexString() : this.getString();
    }

    protected String toHexString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        for (int i = 0; i < this.value.length; ++i) {
            int c = this.value[i] & 0xFF;
            result.append(COSFilterASCIIHexEncode.asciiHexBig[c]);
            result.append(COSFilterASCIIHexEncode.asciiHexLittle[c]);
        }
        result.append('>');
        return result.toString();
    }

    protected String toLitString() {
        StringBuilder result = new StringBuilder();
        result.append('(');
        block10: for (int i = 0; i < this.value.length; ++i) {
            byte ch = this.value[i];
            switch (ch) {
                case 40: {
                    result.append("\\(");
                    continue block10;
                }
                case 41: {
                    result.append("\\)");
                    continue block10;
                }
                case 10: {
                    result.append('\n');
                    continue block10;
                }
                case 13: {
                    result.append('\r');
                    continue block10;
                }
                case 9: {
                    result.append('\t');
                    continue block10;
                }
                case 8: {
                    result.append('\b');
                    continue block10;
                }
                case 12: {
                    result.append('\f');
                    continue block10;
                }
                case 92: {
                    result.append('\\');
                    continue block10;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        result.append(')');
        return result.toString();
    }

    public String getLitString() {
        return this.toLitString();
    }

    public boolean isContainsOnlyHex() {
        return this.containsOnlyHex;
    }

    public void setContainsOnlyHex(boolean containsOnlyHex) {
        this.containsOnlyHex = containsOnlyHex;
    }

    public long getHexCount() {
        return this.hexCount;
    }

    public void setHexCount(long hexCount) {
        this.hexCount = hexCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSString)) {
            return false;
        }
        COSString cosString = (COSString)o;
        if (this.isHex != cosString.isHex) {
            return false;
        }
        if (this.containsOnlyHex != cosString.containsOnlyHex) {
            return false;
        }
        if (this.hexCount != cosString.hexCount) {
            return false;
        }
        return this.value != null ? this.value.equals(cosString.value) : cosString.value == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.isHex ? 1 : 0);
        result = 31 * result + (this.containsOnlyHex ? 1 : 0);
        result = 31 * result + (int)(this.hexCount ^ this.hexCount >>> 32);
        return result;
    }
}

