/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos.filters;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.verapdf.as.filters.io.ASBufferingInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.filters.COSFilterRC4DecryptionDefault;

public class COSFilterAESDecryptionDefault
extends ASBufferingInFilter {
    private static final byte[] SALT_BYTES = new byte[]{115, 65, 108, 84};
    private Cipher aes;
    private int decryptedPointer;
    private byte[] decryptedBytes;
    private boolean decryptingCOSStream;
    private boolean haveReadStream;

    public COSFilterAESDecryptionDefault(ASInputStream stream, COSKey objectKey, byte[] encryptionKey, boolean decryptingCOSStream) throws IOException, GeneralSecurityException {
        super(stream);
        this.initAES(objectKey, encryptionKey);
        this.decryptedBytes = new byte[0];
        this.decryptedPointer = 0;
        this.decryptingCOSStream = decryptingCOSStream;
        this.haveReadStream = false;
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        int bytesFed;
        int readDecrypted;
        if (this.getInputStream() == null) {
            return -1;
        }
        if (this.decryptingCOSStream && !this.haveReadStream) {
            this.getInputStream().skip(16);
            this.haveReadStream = true;
        }
        if ((readDecrypted = this.readFromDecryptedBytes(buffer, size)) != -1) {
            return readDecrypted;
        }
        if (this.bufferSize() <= 0 && (bytesFed = (int)this.feedBuffer(this.getBufferCapacity())) == -1) {
            return -1;
        }
        byte[] encData = new byte[2048];
        int encDataLength = this.bufferPopArray(encData, 2048);
        try {
            this.decryptedBytes = this.aes.update(encData, 0, encDataLength);
            byte[] fin = this.aes.doFinal();
            this.decryptedBytes = COSFilterAESDecryptionDefault.concatenate(this.decryptedBytes, this.decryptedBytes.length, fin, fin.length);
            return this.readFromDecryptedBytes(buffer, size);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Can't decrypt AES data.");
        }
    }

    private void initAES(COSKey objectKey, byte[] encryptionKey) throws IOException, GeneralSecurityException {
        byte[] objectKeyDigest = COSFilterRC4DecryptionDefault.getObjectKeyDigest(objectKey);
        byte[] encWithObjectKey = COSFilterAESDecryptionDefault.concatenate(encryptionKey, encryptionKey.length, objectKeyDigest, objectKeyDigest.length);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(COSFilterAESDecryptionDefault.concatenate(encWithObjectKey, encWithObjectKey.length, SALT_BYTES, SALT_BYTES.length));
        byte[] resultEncryptionKey = md5.digest();
        int keyLength = Math.min(16, resultEncryptionKey.length);
        SecretKeySpec key = new SecretKeySpec(Arrays.copyOf(resultEncryptionKey, keyLength), "AES");
        IvParameterSpec initializingVector = new IvParameterSpec(this.getAESInitializingVector());
        this.aes = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.aes.init(2, (Key)key, initializingVector);
    }

    private byte[] getAESInitializingVector() throws IOException {
        byte[] initVector = new byte[16];
        if (this.getInputStream() == null || this.getInputStream().read(initVector, 16) != 16) {
            throw new IOException("Can't initialize AES cipher: AES initializing vector is not fully read.");
        }
        return initVector;
    }

    private int readFromDecryptedBytes(byte[] buffer, int size) {
        if (this.decryptedBytes.length == this.decryptedPointer) {
            return -1;
        }
        int actualRead = Math.min(size, this.decryptedBytes.length - this.decryptedPointer);
        System.arraycopy(this.decryptedBytes, this.decryptedPointer, buffer, 0, actualRead);
        this.decryptedPointer += actualRead;
        return actualRead;
    }
}

