/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.tools.TypeConverter;

public class PDType3Font
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDType3Font.class.getCanonicalName());

    public PDType3Font(COSDictionary dictionary) {
        super(dictionary);
        this.setSuccessfullyParsed(true);
    }

    public COSDictionary getCharProcDict() {
        return (COSDictionary)this.dictionary.getKey(ASAtom.CHAR_PROCS).getDirectBase();
    }

    @Override
    public FontProgram getFontProgram() {
        return null;
    }

    public PDResources getResources() {
        COSObject resources = this.dictionary.getKey(ASAtom.RESOURCES);
        if (!resources.empty() && resources.getType() == COSObjType.COS_DICT) {
            if (resources.isIndirect().booleanValue()) {
                resources = resources.getDirect();
            }
            return new PDResources(resources);
        }
        return new PDResources(COSDictionary.construct());
    }

    @Override
    public String getName() {
        return this.dictionary.getStringKey(ASAtom.NAME);
    }

    public boolean containsCharString(int code) {
        String glyphName = this.getEncodingMapping().getName(code);
        COSDictionary charProcs = this.getCharProcs();
        if (charProcs != null) {
            ASAtom asAtomGlyph = ASAtom.getASAtom(glyphName);
            return charProcs.knownKey(asAtomGlyph);
        }
        return false;
    }

    public double[] getFontBoundingBox() {
        COSObject bbox = this.getKey(ASAtom.FONT_BBOX);
        if (bbox.getType() == COSObjType.COS_ARRAY || bbox.size() == 4) {
            double[] res = new double[4];
            for (int i = 0; i < 4; ++i) {
                COSObject obj = bbox.at(i);
                if (!obj.getType().isNumber()) {
                    String fontName = this.getName() == null ? "" : this.getName();
                    LOGGER.log(Level.FINE, "Font bounding box array for font " + fontName + " contains " + (Object)((Object)obj.getType()));
                    return null;
                }
                res[i] = obj.getReal();
            }
            return res;
        }
        String fontName = this.getName() == null ? "" : this.getName();
        LOGGER.log(Level.FINE, "Font bounding box array for font " + fontName + " is not an array of 4 elements");
        return null;
    }

    public double[] getFontMatrix() {
        return TypeConverter.getRealArray(this.getKey(ASAtom.FONT_MATRIX), 6, "Font matrix");
    }

    private COSDictionary getCharProcs() {
        return (COSDictionary)this.dictionary.getKey(ASAtom.CHAR_PROCS).getDirectBase();
    }
}

