/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASFileInStream;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.CMapFactory;
import org.verapdf.tools.IntReference;

public class PDCMap {
    private static final Logger LOGGER = Logger.getLogger(PDCMap.class.getCanonicalName());
    private COSObject cMap;
    private COSDictionary cidSystemInfo;
    private CMap cMapFile = null;
    private boolean parsedCMap = false;

    public PDCMap(COSObject cMap) {
        this.cMap = cMap == null ? COSObject.getEmpty() : cMap;
    }

    public String getCMapName() {
        COSObject cMapName;
        if (this.cMap.getType() == COSObjType.COS_NAME) {
            return this.cMap.getString();
        }
        if (this.cMap.getType() == COSObjType.COS_STREAM && (cMapName = this.cMap.getKey(ASAtom.CMAPNAME)) != COSObject.getEmpty()) {
            return cMapName.getString();
        }
        return "";
    }

    private String getCMapID() {
        if (this.cMap.getType() == COSObjType.COS_STREAM) {
            return "CMap " + this.cMap.getObjectKey().toString();
        }
        if (this.cMap.getType() == COSObjType.COS_NAME) {
            return this.cMap.getString();
        }
        return "";
    }

    public COSObject getcMap() {
        return this.cMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMap getCMapFile() {
        if (this.parsedCMap) return this.cMapFile;
        this.parsedCMap = true;
        if (this.cMap.getType() == COSObjType.COS_STREAM) {
            try (ASInputStream cMapStream2 = this.cMap.getData(COSStream.FilterFlags.DECODE);){
                String cMapName = this.getCMapName();
                if (cMapName == null) {
                    cMapName = this.getCMapID();
                }
                CMap cMap2 = this.cMapFile = CMapFactory.getCMap(cMapName, cMapStream2);
                return cMap2;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't close stream", e);
                return this.cMapFile;
            }
        }
        if (this.cMap.getType() != COSObjType.COS_NAME) return null;
        String name = this.cMap.getString();
        String cMapPath = "/font/cmap/" + name;
        try (ASInputStream cMapStream = PDCMap.loadCMap(cMapPath);){
            CMap cMap = this.cMapFile = CMapFactory.getCMap(this.getCMapName(), cMapStream);
            return cMap;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can't close stream", e);
            return this.cMapFile;
        }
    }

    public String getRegistry() {
        if (this.getCIDSystemInfo() == null) {
            return null;
        }
        return this.getCIDSystemInfo().getStringKey(ASAtom.REGISTRY);
    }

    public String getOrdering() {
        if (this.getCIDSystemInfo() == null) {
            return null;
        }
        return this.getCIDSystemInfo().getStringKey(ASAtom.ORDERING);
    }

    public Long getSupplement() {
        if (this.getCIDSystemInfo() == null) {
            return null;
        }
        return this.getCIDSystemInfo().getIntegerKey(ASAtom.SUPPLEMENT);
    }

    public COSObject getUseCMap() {
        COSObject res = this.cMap.getKey(ASAtom.USE_CMAP);
        return res == null ? COSObject.getEmpty() : res;
    }

    private COSDictionary getCIDSystemInfo() {
        if (this.cMap.getType() == COSObjType.COS_NAME) {
            String registry = this.getCMapFile().getRegistry();
            String ordering = this.getCMapFile().getOrdering();
            int supplement = this.getCMapFile().getSupplement();
            COSDictionary res = (COSDictionary)COSDictionary.construct(ASAtom.REGISTRY, registry).get();
            res.setStringKey(ASAtom.ORDERING, ordering);
            res.setIntegerKey(ASAtom.SUPPLEMENT, supplement);
            return res;
        }
        if (this.cidSystemInfo == null) {
            this.cidSystemInfo = (COSDictionary)this.cMap.getKey(ASAtom.CID_SYSTEM_INFO).getDirectBase();
            return this.cidSystemInfo;
        }
        return this.cidSystemInfo;
    }

    private static ASInputStream loadCMap(String cMapName) {
        try {
            File cMapFile;
            URL res = PDCMap.class.getResource(cMapName);
            if (res == null) {
                throw new IOException("CMap " + cMapName + " can't be found.");
            }
            if (res.toString().startsWith("jar:")) {
                int read;
                cMapFile = File.createTempFile("tempfile", ".tmp");
                InputStream input = PDCMap.class.getResourceAsStream(cMapName);
                FileOutputStream out = new FileOutputStream(cMapFile);
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    ((OutputStream)out).write(bytes, 0, read);
                }
                input.close();
                ((OutputStream)out).close();
                cMapFile.deleteOnExit();
            } else {
                cMapFile = new File(res.getFile());
            }
            if (!cMapFile.exists()) {
                throw new IOException("Error: File " + cMapFile + " not found!");
            }
            return new ASFileInStream(new RandomAccessFile(cMapFile, "r"), 0L, cMapFile.length(), new IntReference(), cMapFile.getAbsolutePath(), true);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error in opening predefined CMap " + cMapName, e);
            return null;
        }
    }

    public String toUnicode(int code) {
        return this.getCMapFile() == null ? null : this.getCMapFile().getUnicode(code);
    }
}

