/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.parser.COSParser;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.stdmetrics.StandardFontMetrics;
import org.verapdf.pd.font.stdmetrics.StandardFontMetricsFactory;
import org.verapdf.pd.font.truetype.TrueTypePredefined;
import org.verapdf.pd.font.type1.Type1FontProgram;

public class PDType1Font
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDType1Font.class.getCanonicalName());
    public static final ASAtom[] STANDARD_FONT_NAMES = new ASAtom[]{ASAtom.COURIER_BOLD, ASAtom.COURIER_BOLD_OBLIQUE, ASAtom.COURIER, ASAtom.COURIER_OBLIQUE, ASAtom.HELVETICA, ASAtom.HELVETICA_BOLD, ASAtom.HELVETICA_BOLD_OBLIQUE, ASAtom.HELVETICA_OBLIQUE, ASAtom.SYMBOL, ASAtom.TIMES_BOLD, ASAtom.TIMES_BOLD_ITALIC, ASAtom.TIMES_ITALIC, ASAtom.TIMES_ROMAN, ASAtom.ZAPF_DINGBATS};
    private Boolean isStandard = null;
    private StandardFontMetrics fontMetrics;

    public PDType1Font(COSDictionary dictionary) {
        super(dictionary);
        if (this.isNameStandard() && this.fontDescriptor.getObject().size() == 0) {
            this.fontMetrics = StandardFontMetricsFactory.getFontMetrics(this.getName());
            this.fontDescriptor = PDFontDescriptor.getDescriptorFromMetrics(this.fontMetrics);
        }
    }

    public Set<String> getDescriptorCharSet() {
        String descriptorCharSetString = this.fontDescriptor.getCharSet();
        if (descriptorCharSetString != null) {
            try {
                ASMemoryInStream stream = new ASMemoryInStream(descriptorCharSetString.getBytes());
                TreeSet<String> descriptorCharSet = new TreeSet<String>();
                COSParser parser = new COSParser(stream);
                COSObject glyphName = parser.nextObject();
                while (!glyphName.empty()) {
                    if (glyphName.getType() == COSObjType.COS_NAME) {
                        descriptorCharSet.add(glyphName.getString());
                    }
                    glyphName = parser.nextObject();
                }
                return descriptorCharSet;
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Can't parse /CharSet entry in Type 1 font descriptor", ex);
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FontProgram getFontProgram() {
        if (this.isFontParsed) {
            return this.fontProgram;
        }
        this.isFontParsed = true;
        if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE)) {
            COSStream type1FontFile = this.fontDescriptor.getFontFile();
            try (ASInputStream fontData = type1FontFile.getData(COSStream.FilterFlags.DECODE);){
                FontProgram fontProgram = this.fontProgram = new Type1FontProgram(fontData, this.getEncodingMapping());
                return fontProgram;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't read Type 1 font program.", e);
            }
        } else if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3)) {
            COSStream type1FontFile = this.fontDescriptor.getFontFile3();
            ASAtom subtype = type1FontFile.getNameKey(ASAtom.SUBTYPE);
            try (ASInputStream fontData = type1FontFile.getData(COSStream.FilterFlags.DECODE);){
                if (subtype == ASAtom.TYPE1C) {
                    FontProgram x2 = this.fontProgram = new CFFFontProgram(fontData, this.getEncodingMapping(), null, this.isSubset());
                    return x2;
                }
                if (subtype == ASAtom.OPEN_TYPE) {
                    FontProgram x2 = this.fontProgram = new OpenTypeFontProgram(fontData, true, this.isSymbolic(), this.getEncoding(), null, this.isSubset());
                    return x2;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't read Type 1 font program.", e);
            }
        }
        this.fontProgram = null;
        return null;
    }

    public Boolean isStandard() {
        if (this.isStandard == null) {
            if (!this.containsDiffs() && !this.isEmbedded() && this.isNameStandard()) {
                this.isStandard = true;
                return this.isStandard;
            }
            this.isStandard = false;
            return this.isStandard;
        }
        return this.isStandard;
    }

    private boolean containsDiffs() {
        Map<Integer, String> differences;
        if (this.dictionary.getKey(ASAtom.ENCODING).getType() == COSObjType.COS_DICT && (differences = this.getDifferences()) != null && differences.size() != 0) {
            String[] baseEncoding = PDType1Font.getBaseEncoding((COSDictionary)this.dictionary.getKey(ASAtom.ENCODING).getDirectBase());
            if (baseEncoding.length == 0) {
                return true;
            }
            for (Map.Entry<Integer, String> entry : differences.entrySet()) {
                if (entry.getValue().equals(baseEncoding[entry.getKey()])) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] getBaseEncoding(COSDictionary encoding) {
        ASAtom baseEncoding = encoding.getNameKey(ASAtom.BASE_ENCODING);
        if (baseEncoding == null) {
            return new String[0];
        }
        if (baseEncoding == ASAtom.MAC_ROMAN_ENCODING) {
            return Arrays.copyOf(TrueTypePredefined.MAC_ROMAN_ENCODING, TrueTypePredefined.MAC_ROMAN_ENCODING.length);
        }
        if (baseEncoding == ASAtom.MAC_EXPERT_ENCODING) {
            return Arrays.copyOf(TrueTypePredefined.MAC_EXPERT_ENCODING, TrueTypePredefined.MAC_EXPERT_ENCODING.length);
        }
        if (baseEncoding == ASAtom.WIN_ANSI_ENCODING) {
            return Arrays.copyOf(TrueTypePredefined.WIN_ANSI_ENCODING, TrueTypePredefined.WIN_ANSI_ENCODING.length);
        }
        return new String[0];
    }

    @Override
    public Double getWidth(int code) {
        if (this.getFontProgram() != null) {
            return super.getWidth(code);
        }
        if (this.fontMetrics != null) {
            StandardFontMetrics metrics = StandardFontMetricsFactory.getFontMetrics(this.getName());
            Encoding enc = this.getEncodingMapping();
            if (metrics != null) {
                return metrics.getWidth(enc.getName(code));
            }
        }
        LOGGER.log(Level.FINE, "Can't get standard metrics");
        return null;
    }

    private boolean isEmbedded() {
        return this.getFontProgram() != null;
    }

    private boolean isNameStandard() {
        ASAtom fontName = this.getDictionary().getNameKey(ASAtom.BASE_FONT);
        for (ASAtom standard : STANDARD_FONT_NAMES) {
            if (standard != fontName) continue;
            return true;
        }
        return false;
    }
}

