/**
 * This file is part of veraPDF Parser, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Parser is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Parser as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Parser as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.pd.font.type1;

/**
 * This class contains all string constants, required in font type1 processing.
 *
 * @author Sergey Shemyakov
 */
public class Type1StringConstants {
    static final String FONT_MATRIX_STRING = "FontMatrix";
    static final String ENCODING_STRING = "Encoding";
    static final String DUP_STRING = "dup";
    static final String DEF_STRING = "def";
    static final String READONLY_STRING = "readonly";
    static final String EEXEC_STRING = "eexec";
    static final String CHAR_STRINGS_STRING = "CharStrings";
    static final String LEN_IV_STRING = "lenIV";
    static final String CLEARTOMARK_STRING = "cleartomark";
    static final String CLOSEFILE = "closefile";
    static final String SUBRS = "Subrs";
    static final String STANDARD_ENCODING_STRING = "StandardEncoding";
    static final String NOACCESS = "noaccess";
    static final String WEIGHT = "Weight";
    static final String ASCENT = "Ascent";
    static final String DESCENT = "Descent";
}
