/**
 * This file is part of veraPDF Parser, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Parser is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Parser as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Parser as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.parser;

import java.io.IOException;

/**
 * @author Maxim Plushchov
 */
public interface BaseParserInputStream {

    int read() throws IOException;

    int read(byte[] buffer) throws IOException;

    byte readByte() throws IOException;

    void unread() throws IOException;

    void unread(int i) throws IOException;

    int peek() throws IOException;

    int skip(int size) throws IOException;

    void close() throws IOException;

    boolean isEOF() throws IOException;
}
