/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type1;

import java.io.IOException;
import java.util.Stack;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFIndex;

public abstract class BaseCharStringParser {
    protected ASInputStream stream;
    protected Stack<CFFNumber> stack;
    private CFFNumber width;
    protected CFFIndex globalSubrs;
    protected CFFIndex localSubrs;
    protected int bias;
    protected int gBias;

    protected BaseCharStringParser(ASInputStream stream) throws IOException {
        this.stream = stream;
        this.stack = new Stack();
        this.width = null;
        this.parse();
    }

    protected BaseCharStringParser(ASInputStream stream, CFFIndex localSubrs, int bias, CFFIndex globalSubrs, int gBias) throws IOException {
        this.stream = stream;
        this.stack = new Stack();
        this.width = null;
        this.globalSubrs = globalSubrs == null ? CFFIndex.getEmptyIndex() : globalSubrs;
        this.localSubrs = localSubrs == null ? CFFIndex.getEmptyIndex() : localSubrs;
        this.bias = bias;
        this.gBias = gBias;
        this.parse();
    }

    public CFFNumber getWidth() {
        return this.width;
    }

    protected void setWidth(CFFNumber width) {
        this.width = width;
    }

    private CFFNumber getNextInteger(int firstByte) throws IOException {
        byte[] buf = new byte[1];
        if (firstByte > 31 && firstByte < 247) {
            return new CFFNumber(firstByte - 139);
        }
        if (firstByte > 246 && firstByte < 251) {
            this.stream.read(buf, 1);
            return new CFFNumber((firstByte - 247 << 8) + (buf[0] & 0xFF) + 108);
        }
        if (firstByte > 250 && firstByte < 255) {
            this.stream.read(buf, 1);
            return new CFFNumber(-(firstByte - 251 << 8) - (buf[0] & 0xFF) - 108);
        }
        return this.readNextNumber(firstByte);
    }

    private void parse() throws IOException {
        byte[] buf = new byte[1];
        int cont = this.stream.read(buf, 1);
        while (cont != -1) {
            int nextByte = buf[0] & 0xFF;
            if (nextByte > 31) {
                this.stack.push(this.getNextInteger(nextByte));
            } else if (this.processNextOperator(nextByte)) {
                return;
            }
            cont = this.stream.read(buf, 1);
        }
        this.stack.clear();
    }

    protected void popStack(int num) throws IOException {
        for (int i = 0; i < num && !this.stack.empty(); ++i) {
            this.stack.pop();
        }
    }

    protected abstract boolean processNextOperator(int var1) throws IOException;

    protected abstract CFFNumber readNextNumber(int var1) throws IOException;
}

