/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.factory.fonts;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.font.truetype.PDTrueTypeFont;
import org.verapdf.pd.font.type1.PDType1Font;
import org.verapdf.pd.font.type3.PDType3Font;

public class PDFontFactory {
    private static final Logger LOGGER = Logger.getLogger(PDFontFactory.class.getCanonicalName());

    private PDFontFactory() {
    }

    public static PDFont getPDFont(COSObject fontDictionary) {
        if (fontDictionary != null && fontDictionary.getType() == COSObjType.COS_DICT) {
            COSDictionary dict = (COSDictionary)fontDictionary.getDirectBase();
            ASAtom subtype = fontDictionary.getNameKey(ASAtom.SUBTYPE);
            if (subtype == ASAtom.TYPE1 || subtype == ASAtom.MM_TYPE1) {
                return new PDType1Font(dict);
            }
            if (subtype == ASAtom.TRUE_TYPE) {
                return new PDTrueTypeFont(dict);
            }
            if (subtype == ASAtom.TYPE3) {
                return new PDType3Font(dict);
            }
            if (subtype == ASAtom.TYPE0) {
                return new PDType0Font(dict);
            }
            LOGGER.log(Level.FINE, "Invalid value of Subtype in font dictionary");
            return null;
        }
        LOGGER.log(Level.FINE, "Expected COSDictionary");
        return null;
    }
}

